/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.illumon.iris.db.tables.Table;
import com.illumon.iris.db.tables.utils.DBPeriod;
import com.illumon.iris.db.v2.select.MatchFilter;
import com.illumon.iris.db.v2.select.SelectFilter;
import io.deephaven.plugins.monitoring.ImmutableMetricInterval;
import io.deephaven.plugins.monitoring.Metric;
import io.deephaven.plugins.monitoring.MetricInterval;
import io.deephaven.plugins.monitoring.StatsQueryResults;

public enum Interval {
    T10s("10s"),
    T1m("1m"),
    T5m("5m"),
    T15m("15m");

    private final String metricsInterval;
    private final DBPeriod dbPeriod;
    private final long millis;
    private final int numberOf10s;

    private Interval(String metricsInterval) {
        this.metricsInterval = metricsInterval;
        this.dbPeriod = new DBPeriod("T" + metricsInterval);
        this.millis = this.dbPeriod.getJodaPeriod().toStandardDuration().getMillis();
        this.numberOf10s = (int)(this.millis / 10000L);
        if (this.millis % 10000L != 0L) {
            throw new IllegalArgumentException("Interval must be divisible by 10 seconds");
        }
    }

    public String metricsInterval() {
        return this.metricsInterval;
    }

    public DBPeriod getDbPeriod() {
        return this.dbPeriod;
    }

    public long millis() {
        return this.millis;
    }

    public int getNumberOf10s() {
        return this.numberOf10s;
    }

    public final Table filter(Table input) {
        return input.where(new SelectFilter[]{new MatchFilter(StatsQueryResults.INTERVAL_DEF.getName(), new Object[]{this})});
    }

    public final MetricInterval withMetric(Metric metric) {
        return ImmutableMetricInterval.builder().interval(this).metric(metric).build();
    }
}

