/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import io.deephaven.plugins.monitoring.Formula;
import io.deephaven.plugins.monitoring.Metric;
import io.deephaven.plugins.monitoring.Unit;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IntradayLoggerMetrics {
    public static List<Metric> all() {
        return IntradayLoggerMetrics.descriptors().collect(Collectors.toList());
    }

    public static Stream<Metric> descriptors() {
        return Stream.of(IntradayLoggerMetrics.qoplCount(), IntradayLoggerMetrics.qplCount(), IntradayLoggerMetrics.uplCount(), IntradayLoggerMetrics.metricsCount(), IntradayLoggerMetrics.aelCount(), IntradayLoggerMetrics.pelCount());
    }

    public static Metric qoplCount() {
        return IntradayLoggerMetrics.writtenCount("QueryOperationPerformanceLog", "qopl-count");
    }

    public static Metric qplCount() {
        return IntradayLoggerMetrics.writtenCount("QueryPerformanceLog", "qpl-count");
    }

    public static Metric uplCount() {
        return IntradayLoggerMetrics.writtenCount("UpdatePerformanceLog", "upl-count");
    }

    public static Metric metricsCount() {
        return IntradayLoggerMetrics.writtenCount("ProcessMetrics", "metrics-log-count");
    }

    public static Metric aelCount() {
        return IntradayLoggerMetrics.writtenCount("AuditEventLog", "ael-count");
    }

    public static Metric pelCount() {
        return IntradayLoggerMetrics.writtenCount("ProcessEventLog", "pel-count");
    }

    private static Metric writtenCount(String tablename, String rename) {
        return Metric.builder().name(String.format("Logger-DbInternal-%s.writtenCount", tablename)).rename(rename).unit(Unit.COUNT_PER_MIN).formula(Formula.SUM_PER_MINUTE).build();
    }
}

