/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import io.deephaven.plugins.monitoring.Formula;
import io.deephaven.plugins.monitoring.Metric;
import io.deephaven.plugins.monitoring.Unit;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MemoryMetrics {
    public static List<Metric> all() {
        return MemoryMetrics.descriptors().collect(Collectors.toList());
    }

    public static Stream<Metric> descriptors() {
        return Stream.of(MemoryMetrics.heapUsed(), MemoryMetrics.heapMax(), MemoryMetrics.nonHeapUsed(), MemoryMetrics.directUsed(), MemoryMetrics.edenUsed(), MemoryMetrics.survivorUsed(), MemoryMetrics.oldGenUsed(), MemoryMetrics.codeCacheUsed(), MemoryMetrics.compressClassUsed(), MemoryMetrics.metaspaceUsed(), MemoryMetrics.allocated());
    }

    public static Metric heapUsed() {
        return MemoryMetrics.usedBytes("Heap", "heap-used");
    }

    public static Metric heapMax() {
        return MemoryMetrics.maxBytes("Heap", "heap-max");
    }

    public static Metric nonHeapUsed() {
        return MemoryMetrics.usedBytes("NonHeap", "nonheap-used");
    }

    public static Metric directUsed() {
        return MemoryMetrics.usedBytes("Direct", "direct-used");
    }

    public static Metric edenUsed() {
        return MemoryMetrics.poolUsed("Par Eden Space", "eden-used");
    }

    public static Metric survivorUsed() {
        return MemoryMetrics.poolUsed("Par Survivor Space", "survivor-used");
    }

    public static Metric oldGenUsed() {
        return MemoryMetrics.poolUsed("CMS Old Gen", "oldgen-used");
    }

    public static Metric codeCacheUsed() {
        return MemoryMetrics.poolUsed("Code Cache", "codecache-used");
    }

    public static Metric compressClassUsed() {
        return MemoryMetrics.poolUsed("Compressed Class Space", "compressedclass-used");
    }

    public static Metric metaspaceUsed() {
        return MemoryMetrics.poolUsed("Metaspace", "metaspace-used");
    }

    public static Metric allocated() {
        return Metric.builder().name("Memory.Allocated").rename("memory-allocated").unit(Unit.BYTES_PER_MIN).formula(Formula.SUM_PER_MINUTE).build();
    }

    private static Metric poolUsed(String poolType, String rename) {
        return Metric.builder().name(String.format("Memory-Pool.%s-Used", poolType)).rename(rename).unit(Unit.BYTES).formula(Formula.AVG).build();
    }

    private static Metric usedBytes(String type, String rename) {
        return Metric.builder().name(String.format("Memory-%s.Used", type)).rename(rename).unit(Unit.BYTES).formula(Formula.AVG).build();
    }

    private static Metric maxBytes(String type, String rename) {
        return Metric.builder().name(String.format("Memory-%s.Max", type)).rename(rename).unit(Unit.BYTES).formula(Formula.AVG).build();
    }
}

