/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.illumon.iris.db.tables.Table;
import com.illumon.iris.db.v2.select.MatchFilter;
import com.illumon.iris.db.v2.select.SelectFilter;
import io.deephaven.plugins.monitoring.Formula;
import io.deephaven.plugins.monitoring.ImmutableMetric;
import io.deephaven.plugins.monitoring.ImmutableMetricInterval;
import io.deephaven.plugins.monitoring.Interval;
import io.deephaven.plugins.monitoring.MetricInterval;
import io.deephaven.plugins.monitoring.Unit;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Metric {
    public static Builder builder() {
        return new Builder();
    }

    public abstract String name();

    public abstract String rename();

    public abstract Unit unit();

    public abstract Formula formula();

    public final Table filterColumnByRename(String columnName, Table input) {
        return input.where(new SelectFilter[]{new MatchFilter(columnName, new Object[]{this.rename()})});
    }

    public final MetricInterval t10s() {
        return this.withInterval(Interval.T10s);
    }

    public final MetricInterval t1m() {
        return this.withInterval(Interval.T1m);
    }

    public final MetricInterval t5m() {
        return this.withInterval(Interval.T5m);
    }

    public final MetricInterval t15m() {
        return this.withInterval(Interval.T15m);
    }

    public final MetricInterval withInterval(Interval interval) {
        return ImmutableMetricInterval.builder().metric(this).interval(interval).build();
    }

    public static class Builder
    extends ImmutableMetric.Builder {
    }
}

