/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.illumon.iris.db.tables.utils.TableTools;
import io.deephaven.plugins.monitoring.ImmutableMetricIntervals;
import io.deephaven.plugins.monitoring.ImmutableMetricIntervalsTable;
import io.deephaven.plugins.monitoring.Interval;
import io.deephaven.plugins.monitoring.Metric;
import io.deephaven.plugins.monitoring.MetricInterval;
import io.deephaven.plugins.monitoring.MetricIntervalsTable;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
public abstract class MetricIntervals {
    public static MetricIntervals join(Collection<Metric> metrics, Collection<Interval> intervals) {
        ImmutableMetricIntervals.Builder builder = ImmutableMetricIntervals.builder();
        for (Metric metric : metrics) {
            for (Interval interval : intervals) {
                builder.addMetrics(metric.withInterval(interval));
            }
        }
        return builder.build();
    }

    public abstract Set<MetricInterval> metrics();

    public final MetricIntervalsTable asTable() {
        return ImmutableMetricIntervalsTable.of(TableTools.merge(this.metrics().stream().map(MetricInterval::asTable).collect(Collectors.toList())));
    }

    public final boolean isEmpty() {
        return this.metrics().isEmpty();
    }
}

