/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.illumon.dataobjects.ColumnDefinition;
import com.illumon.iris.db.tables.Table;
import com.illumon.iris.db.tables.TableDefinition;
import io.deephaven.plugins.monitoring.Formula;
import io.deephaven.plugins.monitoring.Helper;
import io.deephaven.plugins.monitoring.ImmutableMetricIntervalsTable;
import io.deephaven.plugins.monitoring.Interval;
import io.deephaven.plugins.monitoring.Unit;
import java.util.Arrays;
import org.immutables.value.Value;

@Value.Immutable(builder=false, copy=false)
public abstract class MetricIntervalsTable {
    public static final ColumnDefinition<String> NAME_DEF = new ColumnDefinition("Name", String.class);
    public static final ColumnDefinition<String> RENAME_DEF = new ColumnDefinition("Rename", String.class);
    public static final ColumnDefinition<Unit> UNIT_DEF = new ColumnDefinition("Unit", Unit.class);
    public static final ColumnDefinition<Interval> INTERVAL_DEF = new ColumnDefinition("Interval", Interval.class);
    public static final ColumnDefinition<Formula> FORMULA_DEF = new ColumnDefinition("Formula", Formula.class);
    public static final TableDefinition EXPECTED_TYPE = new TableDefinition(Arrays.asList(NAME_DEF, RENAME_DEF, UNIT_DEF, INTERVAL_DEF, FORMULA_DEF));

    public static MetricIntervalsTable of(Table table) {
        return ImmutableMetricIntervalsTable.of(table);
    }

    @Value.Parameter
    public abstract Table table();

    public final Table decorateProcessMetrics(Table metrics) {
        Table config = this.tableWithViews();
        return metrics.renameColumns(new String[]{"IntervalMetrics=Interval"}).whereIn(config, new String[]{"Name", "IntervalMetrics"}).exactJoin(config, "Name,IntervalMetrics", "Formula,Rename,Unit,Interval").view(new String[]{"Date", "Timestamp", "ProcessId", "Name=Rename", "Interval", "Unit", "Value=Formula.compute(Interval, N, Sum)"});
    }

    final Table tableWithViews() {
        return this.table().updateView(new String[]{"IntervalMetrics=Interval.metricsInterval()", "IntervalPeriod=Interval.getDbPeriod()"});
    }

    @Value.Check
    final void checkConfigTable() {
        Helper.checkDefinition(EXPECTED_TYPE, this.table().getDefinition());
    }
}

