/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import io.deephaven.plugins.monitoring.Formula;
import io.deephaven.plugins.monitoring.Metric;
import io.deephaven.plugins.monitoring.Unit;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProcMetrics {
    public static List<Metric> all() {
        return ProcMetrics.descriptors().collect(Collectors.toList());
    }

    public static Stream<Metric> descriptors() {
        return Stream.of(ProcMetrics.minorFaults(), ProcMetrics.majorFaults(), ProcMetrics.userCPU(), ProcMetrics.systemCPU(), ProcMetrics.virtualSize(), ProcMetrics.residentPages());
    }

    public static Metric minorFaults() {
        return ProcMetrics.faults("Minor", "minor-faults");
    }

    public static Metric majorFaults() {
        return ProcMetrics.faults("Major", "major-faults");
    }

    public static Metric userCPU() {
        return ProcMetrics.cpu("User", "user-cpu");
    }

    public static Metric systemCPU() {
        return ProcMetrics.cpu("System", "system-cpu");
    }

    public static Metric virtualSize() {
        return Metric.builder().name("Proc.VSZ").rename("virtual-size").unit(Unit.BYTES).formula(Formula.AVG_MULT_1Ki).build();
    }

    public static Metric residentPages() {
        return Metric.builder().name("Proc.RSS").rename("resident-pages").unit(Unit.PAGES).formula(Formula.AVG).build();
    }

    private static Metric faults(String type, String rename) {
        return Metric.builder().name(String.format("Proc.%sFaults", type)).rename(rename).unit(Unit.COUNT_PER_MIN).formula(Formula.SUM_PER_MINUTE).build();
    }

    private static Metric cpu(String type, String rename) {
        return Metric.builder().name(String.format("Proc.%sJiffies", type)).rename(rename).unit(Unit.CPU_PERC).formula(Formula.JIFFIES_TO_CPU_PERC).build();
    }
}

