/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.illumon.iris.db.tables.databases.Database;
import io.deephaven.plugins.monitoring.GCMetrics;
import io.deephaven.plugins.monitoring.ImmutableMetricIntervals;
import io.deephaven.plugins.monitoring.ImmutableProcessDashboard;
import io.deephaven.plugins.monitoring.ImmutableProcessIdInternalDecorationQuery;
import io.deephaven.plugins.monitoring.ImmutableStatsQueryBasic;
import io.deephaven.plugins.monitoring.MemoryMetrics;
import io.deephaven.plugins.monitoring.MetricIntervals;
import io.deephaven.plugins.monitoring.ProcMetrics;
import io.deephaven.plugins.monitoring.ProcessIdDecorationTable;
import io.deephaven.plugins.monitoring.ProcessInfoKeyDescriptor;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ProcessDashboard {
    public static ProcessIdDecorationTable execute(Database db) throws Exception {
        return ImmutableProcessDashboard.builder().db(db).build().execute();
    }

    public abstract Database db();

    @Value.Default
    public boolean includeMetricsTimestamp() {
        return true;
    }

    @Value.Default
    public List<ProcessInfoKeyDescriptor> keys() {
        return Arrays.asList(ProcessInfoKeyDescriptor.startTime(), ProcessInfoKeyDescriptor.processName(), ProcessInfoKeyDescriptor.serviceName(), ProcessInfoKeyDescriptor.hostname(), ProcessInfoKeyDescriptor.pqOwner(), ProcessInfoKeyDescriptor.pqName(), ProcessInfoKeyDescriptor.pid(), ProcessInfoKeyDescriptor.logDir(), ProcessInfoKeyDescriptor.configFile(), ProcessInfoKeyDescriptor.workspace(), ProcessInfoKeyDescriptor.devroot(), ProcessInfoKeyDescriptor.username(), ProcessInfoKeyDescriptor.userDir(), ProcessInfoKeyDescriptor.javaVersion(), ProcessInfoKeyDescriptor.heapMax());
    }

    @Value.Default
    public MetricIntervals metrics() {
        return ImmutableMetricIntervals.builder().addMetrics(ProcMetrics.userCPU().t1m(), ProcMetrics.systemCPU().t1m(), GCMetrics.parnewTime().t1m(), GCMetrics.cmsTime().t1m(), MemoryMetrics.allocated().t1m(), MemoryMetrics.heapUsed().t1m(), MemoryMetrics.directUsed().t1m(), MemoryMetrics.nonHeapUsed().t1m()).build();
    }

    @Value.Default
    public int numDaysDecoration() {
        return 14;
    }

    @Value.Check
    final void checkNumDaysDecoration() {
        if (this.numDaysDecoration() < 1) {
            throw new IllegalArgumentException("numDaysDecoration should be at least 1");
        }
    }

    public final ProcessIdDecorationTable execute() throws Exception {
        ProcessIdDecorationTable todayIds = ProcessIdDecorationTable.ofStartedCurrentDateNy(this.db());
        ProcessIdDecorationTable metricsTimestamp = ProcessIdDecorationTable.ofMetricsTimestamp(this.db());
        ProcessIdDecorationTable processIdInternal = ImmutableProcessIdInternalDecorationQuery.builder().db(this.db()).keys(this.keys()).numDays(this.numDaysDecoration()).build().execute();
        ProcessIdDecorationTable importantMetrics = ImmutableStatsQueryBasic.builder().db(this.db()).metrics(this.metrics()).startupTime(Instant.EPOCH).build().execute().asProcessIdDecorator(this.metrics());
        return ProcessIdDecorationTable.combine(Arrays.asList(todayIds, metricsTimestamp), Arrays.asList(processIdInternal, this.includeMetricsTimestamp() ? metricsTimestamp : ProcessIdDecorationTable.empty(), importantMetrics));
    }
}

