/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.illumon.dataobjects.ColumnDefinition;
import com.illumon.iris.db.tables.Table;
import com.illumon.iris.db.tables.TableDefinition;
import com.illumon.iris.db.tables.databases.Database;
import com.illumon.iris.db.tables.utils.TableTools;
import com.illumon.iris.db.v2.utils.ColumnHolder;
import io.deephaven.plugins.monitoring.ImmutableProcessIdDecorationTable;
import io.deephaven.plugins.monitoring.ImmutableProcessIdMetricsTimestampDecorationQuery;
import io.deephaven.plugins.monitoring.ImmutableProcessIdPqQueryBasic;
import io.deephaven.plugins.monitoring.ImmutableProcessIdProcessNameQueryBasic;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable(builder=false, copy=false)
public abstract class ProcessIdDecorationTable {
    public static final ColumnDefinition<String> PROCESS_ID_DEF = new ColumnDefinition("ProcessId", String.class);

    public static ProcessIdDecorationTable empty() {
        return ImmutableProcessIdDecorationTable.of(TableTools.emptyTable((long)0L, (TableDefinition)new TableDefinition(Collections.singletonList(PROCESS_ID_DEF))));
    }

    public static ProcessIdDecorationTable of(String processId) {
        return ImmutableProcessIdDecorationTable.of((Table)TableTools.newTable((ColumnHolder[])new ColumnHolder[]{TableTools.stringCol((String)PROCESS_ID_DEF.getName(), (String[])new String[]{processId})}));
    }

    public static ProcessIdDecorationTable ofStartedCurrentDateNy(Database db) {
        return ImmutableProcessIdDecorationTable.of(db.i("DbInternal", "ProcessInfo").where(new String[]{"Date=currentDateNy()"}).selectDistinct(new String[]{"ProcessId=Id"}));
    }

    public static ProcessIdDecorationTable ofPQ(Database db, String pqOwner, String pqName) {
        return ImmutableProcessIdPqQueryBasic.of(db, pqOwner, pqName).execute();
    }

    public static ProcessIdDecorationTable ofProcessName(Database db, String processName) {
        return ImmutableProcessIdProcessNameQueryBasic.of(db, processName).execute();
    }

    public static ProcessIdDecorationTable ofMetricsTimestamp(Database db) {
        return ImmutableProcessIdMetricsTimestampDecorationQuery.of(db).execute();
    }

    public static ProcessIdDecorationTable combine(List<ProcessIdDecorationTable> forIds, List<ProcessIdDecorationTable> forDecoration) {
        List processIds = forIds.stream().map(ProcessIdDecorationTable::table).map(t -> t.view(new String[]{PROCESS_ID_DEF.getName()})).collect(Collectors.toList());
        Table joined = TableTools.merge(processIds).selectDistinct(new String[]{PROCESS_ID_DEF.getName()});
        for (ProcessIdDecorationTable pidt : forDecoration) {
            joined = joined.naturalJoin(pidt.table(), PROCESS_ID_DEF.getName());
        }
        return ImmutableProcessIdDecorationTable.of(joined);
    }

    @Value.Parameter
    public abstract Table table();

    public final Table decorateOnto(Table other) {
        return other.naturalJoin(this.table(), PROCESS_ID_DEF.getName());
    }

    @Value.Check
    final void checkDefinition() {
        if (this.table().getDefinition().getColumnIndex(PROCESS_ID_DEF) < 0) {
            throw new IllegalArgumentException("ProcessId column not found");
        }
    }
}

