/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.illumon.iris.db.tables.Table;
import com.illumon.iris.db.tables.databases.Database;
import com.illumon.iris.db.tables.select.MatchPair;
import com.illumon.iris.db.tables.utils.DBTimeUtils;
import com.illumon.iris.db.tables.utils.TableTools;
import com.illumon.iris.db.v2.utils.ColumnHolder;
import io.deephaven.plugins.monitoring.ImmutableProcessIdDecorationTable;
import io.deephaven.plugins.monitoring.ProcessIdDecorationTable;
import io.deephaven.plugins.monitoring.ProcessInfoKeyDescriptor;
import java.time.LocalDate;
import java.util.List;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ProcessIdInternalDecorationQuery {
    public static String daysAgoNy(int daysAgo) {
        return LocalDate.parse(DBTimeUtils.currentDateNy()).minusDays(daysAgo).toString();
    }

    public abstract Database db();

    public abstract List<ProcessInfoKeyDescriptor> keys();

    public abstract int numDays();

    public final ProcessIdDecorationTable execute() {
        String filterStr = this.numDays() == 1 ? "Date=currentDateNy()" : String.format("Date>=io.deephaven.plugins.monitoring.ProcessIdInternalDecorationQuery.daysAgoNy(%d)", this.numDays() - 1);
        Table pi = this.db().i("DbInternal", "ProcessInfo").where(new String[]{filterStr}).updateView(new String[]{"ProcessId=Id"});
        Table keys = pi.whereIn(this.filter(), new String[]{"Type", "Key"});
        Table decorated = pi.selectDistinct(new String[]{"ProcessId"});
        for (ProcessInfoKeyDescriptor desc : this.keys()) {
            decorated = decorated.naturalJoin(Table.JoinStrategy.DEFAULT, desc.applyFilter(keys), new MatchPair[]{new MatchPair("ProcessId", "ProcessId")}, new MatchPair[]{new MatchPair(desc.rename(), "Value")});
            if (!desc.formula().isPresent()) continue;
            String formula = desc.formula().get().replace("{col}", desc.rename());
            decorated = decorated.update(new String[]{String.format("%s=%s", desc.rename(), formula)});
        }
        return ImmutableProcessIdDecorationTable.of(decorated);
    }

    private Table filter() {
        return TableTools.newTable((ColumnHolder[])new ColumnHolder[]{TableTools.stringCol((String)"Type", (String[])((String[])this.keys().stream().map(ProcessInfoKeyDescriptor::type).toArray(String[]::new))), TableTools.stringCol((String)"Key", (String[])((String[])this.keys().stream().map(ProcessInfoKeyDescriptor::key).toArray(String[]::new)))});
    }

    @Value.Check
    final void checkDays() {
        if (this.numDays() < 1) {
            throw new IllegalArgumentException("numDays() must be at least 1");
        }
    }
}

