/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.illumon.dataobjects.ColumnDefinition;
import com.illumon.iris.db.tables.Table;
import com.illumon.iris.db.tables.TableDefinition;
import com.illumon.iris.db.tables.databases.Database;
import io.deephaven.plugins.monitoring.Helper;
import io.deephaven.plugins.monitoring.ImmutableProcessIdDecorationTable;
import io.deephaven.plugins.monitoring.ProcessIdDecorationTable;
import java.util.Arrays;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ProcessIdPqDecorationQuery {
    public static final ColumnDefinition<String> OWNER_DEF = new ColumnDefinition("Owner", String.class);
    public static final ColumnDefinition<String> NAME_DEF = new ColumnDefinition("Name", String.class);
    public static final TableDefinition EXPECTED_TYPE = new TableDefinition(Arrays.asList(OWNER_DEF, NAME_DEF));

    public abstract Database db();

    public abstract Optional<Table> pqOwnerNameFilter();

    public final ProcessIdDecorationTable execute() {
        Table pqclv2 = this.db().i("DbInternal", "PersistentQueryConfigurationLogV2");
        Table pqclv2Filtered = this.pqOwnerNameFilter().isPresent() ? pqclv2.whereIn(this.pqOwnerNameFilter().get(), new String[]{"Owner", "Name"}) : pqclv2;
        Table serialNumbers = pqclv2Filtered.selectDistinct(new String[]{"SerialNumber"});
        Table pqLatest = pqclv2.whereIn(serialNumbers, new String[]{"SerialNumber"}).view(new String[]{"SerialNumber", "PqOwner=Owner", "PqName=Name", "PqVersion=VersionNumber"}).lastBy(new String[]{"SerialNumber"});
        Table processInfo = this.db().i("DbInternal", "ProcessInfo").where(new String[]{"Date=currentDateNy()", "Type=`env-var`", "Key=`PQ_SERIAL`"}).updateView(new String[]{"SerialNumber=Long.parseLong(Value)"}).whereIn(pqLatest, new String[]{"SerialNumber"}).exactJoin(pqLatest, "SerialNumber", "PqSerial=SerialNumber,PqOwner,PqName").view(new String[]{"ProcessId=Id", "PqSerial", "PqOwner", "PqName"});
        return ImmutableProcessIdDecorationTable.of(processInfo);
    }

    @Value.Check
    final void checkConfig() {
        if (this.pqOwnerNameFilter().isPresent()) {
            Helper.checkDefinition(EXPECTED_TYPE, this.pqOwnerNameFilter().get().getDefinition());
        }
    }
}

