/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.illumon.iris.db.tables.Table;
import com.illumon.iris.db.v2.select.MatchFilter;
import com.illumon.iris.db.v2.select.SelectFilter;
import io.deephaven.plugins.monitoring.ImmutableProcessInfoKeyDescriptor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ProcessInfoKeyDescriptor {
    public static final String TYPE_COL_NAME = "Type";
    public static final String KEY_COL_NAME = "Key";
    private static final String SYSTEM_INFO_OS_TYPE = "system-info.os";
    private static final String ENV_VAR_TYPE = "env-var";
    private static final String RUNTIME_MX_SYS_PROPS_TYPE = "runtime-mx.sys-props";
    private static final String RUNTIME_MX_TYPE = "runtime-mx";
    private static final String MEMORY_MX_HEAP_TYPE = "memory-mx.heap";

    public abstract String type();

    public abstract String key();

    public abstract String rename();

    public abstract Optional<String> formula();

    public final Table applyFilter(Table input) {
        return input.where(new SelectFilter[]{new MatchFilter(TYPE_COL_NAME, new Object[]{this.type()}), new MatchFilter(KEY_COL_NAME, new Object[]{this.key()})});
    }

    public static String getCanonicalHost(String name) {
        try {
            return InetAddress.getByName(name).getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            return name;
        }
    }

    public static ProcessInfoKeyDescriptor serviceName() {
        return ProcessInfoKeyDescriptor.stringProp("service.name", "ServiceName");
    }

    public static ProcessInfoKeyDescriptor processName() {
        return ProcessInfoKeyDescriptor.stringProp("process.name", "ProcessName");
    }

    public static ProcessInfoKeyDescriptor javaVersion() {
        return ProcessInfoKeyDescriptor.stringProp("java.version", "JavaVersion");
    }

    public static ProcessInfoKeyDescriptor username() {
        return ProcessInfoKeyDescriptor.stringProp("user.name", "UserName");
    }

    public static ProcessInfoKeyDescriptor workspace() {
        return ProcessInfoKeyDescriptor.stringProp("workspace", "Workspace");
    }

    public static ProcessInfoKeyDescriptor configFile() {
        return ProcessInfoKeyDescriptor.stringProp("Configuration.rootFile", "ConfigFile");
    }

    public static ProcessInfoKeyDescriptor devroot() {
        return ProcessInfoKeyDescriptor.stringProp("devroot", "DevRoot");
    }

    public static ProcessInfoKeyDescriptor logDir() {
        return ProcessInfoKeyDescriptor.stringProp("logDir", "LogDir");
    }

    public static ProcessInfoKeyDescriptor userDir() {
        return ProcessInfoKeyDescriptor.stringProp("user.dir", "UserDir");
    }

    public static ProcessInfoKeyDescriptor hostname() {
        return ImmutableProcessInfoKeyDescriptor.builder().type(SYSTEM_INFO_OS_TYPE).key("network.hostname").rename("Host").build();
    }

    public static ProcessInfoKeyDescriptor canonicalHostname() {
        return ImmutableProcessInfoKeyDescriptor.builder().type(SYSTEM_INFO_OS_TYPE).key("network.hostname").rename("CanonicalHost").formula("io.deephaven.monitoring.stats.ProcessInfoKeyDescriptor.getCanonicalHost({col})").build();
    }

    public static ProcessInfoKeyDescriptor pqSerial() {
        return ImmutableProcessInfoKeyDescriptor.builder().type(ENV_VAR_TYPE).key("PQ_SERIAL").rename("PqSerial").formula("isNull({col}) ? NULL_LONG : Long.parseLong({col})").build();
    }

    public static ProcessInfoKeyDescriptor pqOwner() {
        return ImmutableProcessInfoKeyDescriptor.builder().type(ENV_VAR_TYPE).key("PQ_OWNER").rename("PqOwner").build();
    }

    public static ProcessInfoKeyDescriptor pqName() {
        return ImmutableProcessInfoKeyDescriptor.builder().type(ENV_VAR_TYPE).key("PQ_NAME").rename("PqName").build();
    }

    public static ProcessInfoKeyDescriptor pqVersion() {
        return ImmutableProcessInfoKeyDescriptor.builder().type(ENV_VAR_TYPE).key("PQ_VERSION").rename("PqVersion").formula("isNull({col}) ? NULL_LONG : Long.parseLong({col})").build();
    }

    public static ProcessInfoKeyDescriptor startTime() {
        return ImmutableProcessInfoKeyDescriptor.builder().type(RUNTIME_MX_TYPE).key("start-time").rename("StartTime").formula("isNull({col}) ? (DBDateTime)null : millisToTime(Long.parseLong({col}))").build();
    }

    public static ProcessInfoKeyDescriptor pid() {
        return ImmutableProcessInfoKeyDescriptor.builder().type(SYSTEM_INFO_OS_TYPE).key("pid").rename("Pid").formula("isNull({col}) ? NULL_LONG : Long.parseLong({col})").build();
    }

    public static ProcessInfoKeyDescriptor heapInit() {
        return ImmutableProcessInfoKeyDescriptor.builder().type(MEMORY_MX_HEAP_TYPE).key("init").rename("HeapInit").formula("isNull({col}) ? NULL_LONG : Long.parseLong({col})").build();
    }

    public static ProcessInfoKeyDescriptor heapMax() {
        return ImmutableProcessInfoKeyDescriptor.builder().type(MEMORY_MX_HEAP_TYPE).key("max").rename("HeapMax").formula("isNull({col}) ? NULL_LONG : Long.parseLong({col})").build();
    }

    private static ProcessInfoKeyDescriptor stringProp(String key, String rename) {
        return ImmutableProcessInfoKeyDescriptor.builder().type(RUNTIME_MX_SYS_PROPS_TYPE).key(key).rename(rename).build();
    }
}

