/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.illumon.iris.db.plot.Figure;
import com.illumon.iris.db.plot.PlottingConvenience;
import com.illumon.iris.db.tables.Table;
import com.illumon.iris.db.tables.databases.Database;
import com.illumon.iris.db.tables.select.QueryScope;
import io.deephaven.plugins.monitoring.GCMetrics;
import io.deephaven.plugins.monitoring.ImmutableMetricIntervals;
import io.deephaven.plugins.monitoring.ImmutableStatsGraphDashboard;
import io.deephaven.plugins.monitoring.ImmutableStatsGraphQuery;
import io.deephaven.plugins.monitoring.Interval;
import io.deephaven.plugins.monitoring.IntradayLoggerMetrics;
import io.deephaven.plugins.monitoring.MemoryMetrics;
import io.deephaven.plugins.monitoring.Metric;
import io.deephaven.plugins.monitoring.MetricInterval;
import io.deephaven.plugins.monitoring.MetricIntervals;
import io.deephaven.plugins.monitoring.ProcMetrics;
import io.deephaven.plugins.monitoring.ProcessIdDecorationTable;
import io.deephaven.plugins.monitoring.StatsGraphQuery;
import io.deephaven.plugins.monitoring.Unit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable
public abstract class StatsGraphDashboard {
    public static StatsGraphDashboard of(Database db, ProcessIdDecorationTable processIds) {
        return ImmutableStatsGraphDashboard.builder().db(db).processIds(processIds).build();
    }

    public static void execute(Database db, ProcessIdDecorationTable processIds) {
        StatsGraphDashboard.of(db, processIds).execute();
    }

    public abstract Database db();

    public abstract ProcessIdDecorationTable processIds();

    public abstract Optional<String> since();

    @Value.Default
    public MetricIntervals memory() {
        return ImmutableMetricIntervals.builder().addMetrics(MemoryMetrics.edenUsed().t10s(), MemoryMetrics.survivorUsed().t10s(), MemoryMetrics.heapUsed().t10s(), MemoryMetrics.heapMax().t10s(), MemoryMetrics.oldGenUsed().t10s(), MemoryMetrics.directUsed().t10s(), MemoryMetrics.nonHeapUsed().t10s()).build();
    }

    @Value.Default
    public MetricIntervals cpu() {
        return MetricIntervals.join(Arrays.asList(ProcMetrics.userCPU(), ProcMetrics.systemCPU()), Arrays.asList(Interval.T1m, Interval.T5m));
    }

    @Value.Default
    public MetricIntervals gcCount() {
        return MetricIntervals.join(Arrays.asList(GCMetrics.parnewCount(), GCMetrics.cmsCount()), Arrays.asList(Interval.T1m, Interval.T5m));
    }

    @Value.Default
    public MetricIntervals gcTime() {
        return MetricIntervals.join(Arrays.asList(GCMetrics.parnewTime(), GCMetrics.cmsTime()), Arrays.asList(Interval.T1m, Interval.T5m));
    }

    @Value.Default
    public MetricIntervals memoryAllocated() {
        return MetricIntervals.join(Arrays.asList(MemoryMetrics.allocated(), GCMetrics.reclaimed()), Collections.singleton(Interval.T1m));
    }

    @Value.Default
    public MetricIntervals loggers() {
        return MetricIntervals.join(IntradayLoggerMetrics.all(), Collections.singletonList(Interval.T5m));
    }

    @Value.Check
    final void checkUnits() {
        this.checkAtMostOneUnit(this.memory());
        this.checkAtMostOneUnit(this.cpu());
        this.checkAtMostOneUnit(this.gcCount());
        this.checkAtMostOneUnit(this.gcTime());
        this.checkAtMostOneUnit(this.memoryAllocated());
        this.checkAtMostOneUnit(this.loggers());
    }

    final Optional<Unit> checkAtMostOneUnit(MetricIntervals metricIntervals) {
        List units = metricIntervals.metrics().stream().map(MetricInterval::metric).map(Metric::unit).distinct().collect(Collectors.toList());
        if (units.isEmpty()) {
            return Optional.empty();
        }
        if (units.size() > 1) {
            throw new IllegalArgumentException("Can't have a graph with multiple units");
        }
        return Optional.of(units.get(0));
    }

    public final List<Query> queries() {
        return Stream.of(this.memoryQuery(), this.memoryAllocatedQuery(), this.cpuQuery(), this.gcCountQuery(), this.gcTimeQuery(), this.loggersQuery()).collect(Collectors.toList());
    }

    public final Query loggersQuery() {
        return new Query("loggers", this.loggers());
    }

    public final Query gcTimeQuery() {
        return new Query("gcTime", this.gcTime());
    }

    public final Query gcCountQuery() {
        return new Query("gcCount", this.gcCount());
    }

    public final Query memoryAllocatedQuery() {
        return new Query("memoryAllocated", this.memoryAllocated());
    }

    public final Query cpuQuery() {
        return new Query("cpu", this.cpu());
    }

    public final Query memoryQuery() {
        return new Query("memory", this.memory());
    }

    public final void execute() {
        this.execute(QueryScope.getDefaultInstance());
    }

    public final void execute(QueryScope scope) {
        for (Query query : this.queries()) {
            if (query.metrics.isEmpty()) continue;
            Figure plot = query.plot();
            scope.putParam(query.name, (Object)plot);
        }
    }

    public class Query {
        private final String name;
        private final MetricIntervals metrics;

        private Query(String name, MetricIntervals metrics) {
            this.name = Objects.requireNonNull(name);
            this.metrics = Objects.requireNonNull(metrics);
        }

        public StatsGraphQuery query() {
            ImmutableStatsGraphQuery.Builder builder = ImmutableStatsGraphQuery.builder().db(StatsGraphDashboard.this.db()).processIds(StatsGraphDashboard.this.processIds()).metrics(this.metrics.asTable());
            StatsGraphDashboard.this.since().ifPresent(builder::since);
            return builder.build();
        }

        public Figure plot() {
            Table metrics = this.query().execute().metrics().update(new String[]{"Interval=Interval.metricsInterval()"});
            return PlottingConvenience.plotBy((Comparable)((Object)""), (Table)metrics, (String)"Timestamp", (String)"Value", (String[])new String[]{"Name", "Interval"}).chartTitle("Metrics: " + this.name).yLabel(StatsGraphDashboard.this.checkAtMostOneUnit(this.metrics).get().friendlyName()).show();
        }
    }
}

