/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.illumon.iris.db.tables.Table;
import com.illumon.iris.db.tables.databases.Database;
import io.deephaven.plugins.monitoring.ImmutableStatsGraphResults;
import io.deephaven.plugins.monitoring.MetricIntervalsTable;
import io.deephaven.plugins.monitoring.ProcessIdDecorationTable;
import io.deephaven.plugins.monitoring.StatsGraphResults;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class StatsGraphQuery {
    public abstract Database db();

    public abstract ProcessIdDecorationTable processIds();

    public abstract MetricIntervalsTable metrics();

    public abstract Optional<String> since();

    public final StatsGraphResults execute() {
        Table processIds = this.processIds().table();
        String dateFilter = this.since().map(since -> String.format("Date>=`%s`", since)).orElse("Date=currentDateNy()");
        Table raw = this.db().i("DbInternal", "ProcessMetrics").where(new String[]{dateFilter}).whereIn(processIds, new String[]{"ProcessId"});
        Table metrics = this.metrics().decorateProcessMetrics(raw).exactJoin(processIds, "ProcessId");
        return ImmutableStatsGraphResults.builder().query(this).metrics(metrics).build();
    }
}

