/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.illumon.dataobjects.ColumnDefinition;
import com.illumon.iris.db.tables.Table;
import com.illumon.iris.db.tables.TableDefinition;
import com.illumon.iris.db.tables.databases.Database;
import com.illumon.iris.db.tables.utils.DBDateTime;
import io.deephaven.plugins.monitoring.Helper;
import io.deephaven.plugins.monitoring.ImmutableStatsQueryResults;
import io.deephaven.plugins.monitoring.MetricIntervalsTable;
import io.deephaven.plugins.monitoring.StatsQueryResults;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import org.immutables.value.Value;

@Value.Immutable
public abstract class StatsQuery {
    public static final TableDefinition EXPECTED_STARTUP_TYPE = new TableDefinition(Collections.singletonList(new ColumnDefinition("StartupTime", DBDateTime.class)));

    public static String getHost(String name) {
        try {
            return InetAddress.getByName(name).getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            return name;
        }
    }

    public abstract Database db();

    public abstract Table ticking();

    public abstract MetricIntervalsTable metrics();

    public abstract Table startupTime();

    public final StatsQueryResults execute() {
        Table m4;
        Table metricsFilter = this.metrics().tableWithViews();
        Table m1 = this.db().i("DbInternal", "ProcessMetrics").where(new String[]{"Date=currentDateNy()"}).naturalJoin(this.startupTime(), "").where(new String[]{"Timestamp >= StartupTime"}).dropColumns(new String[]{"StartupTime"});
        Table m2 = m1.renameColumns(new String[]{"IntervalMetrics=Interval"}).whereIn(metricsFilter, new String[]{"Name", "IntervalMetrics"});
        Table m3 = this.ticking().snapshotIncremental(m2.lastBy(new String[]{"Date", "ProcessId", "Name", "IntervalMetrics"}), new String[0]);
        Table m5 = m4 = m3.exactJoin(metricsFilter, "Name,IntervalMetrics", "Formula,Rename,Unit,Interval,IntervalPeriod");
        Table m6 = m5.view(new String[]{"Date", "Timestamp", "ProcessId", "Name=Rename", "Interval", "Unit", "Value=Formula.compute(Interval, N, Sum)"});
        return ImmutableStatsQueryResults.builder().query(this).metrics(m6).build();
    }

    @Value.Check
    final void checkStartupTime() {
        Helper.checkDefinition(EXPECTED_STARTUP_TYPE, this.startupTime().getDefinition());
        if (this.startupTime().size() != 1L) {
            throw new IllegalArgumentException("Expected startupTime table to contain exactly 1 element");
        }
    }
}

