/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.illumon.iris.db.tables.Table;
import com.illumon.iris.db.tables.databases.Database;
import com.illumon.iris.db.tables.utils.DBDateTime;
import com.illumon.iris.db.tables.utils.DBTimeUtils;
import com.illumon.iris.db.tables.utils.TableTools;
import com.illumon.iris.db.v2.DynamicTable;
import com.illumon.iris.db.v2.utils.ColumnHolder;
import io.deephaven.plugins.monitoring.GCMetrics;
import io.deephaven.plugins.monitoring.ImmutableStatsQuery;
import io.deephaven.plugins.monitoring.ImmutableStatsQueryBasic;
import io.deephaven.plugins.monitoring.Interval;
import io.deephaven.plugins.monitoring.IntradayLoggerMetrics;
import io.deephaven.plugins.monitoring.MemoryMetrics;
import io.deephaven.plugins.monitoring.Metric;
import io.deephaven.plugins.monitoring.MetricIntervals;
import io.deephaven.plugins.monitoring.ProcMetrics;
import io.deephaven.plugins.monitoring.StatsQuery;
import io.deephaven.plugins.monitoring.StatsQueryResults;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable
public abstract class StatsQueryBasic {
    public static StatsQueryResults execute(Database db) throws Exception {
        return ImmutableStatsQueryBasic.builder().db(db).build().execute();
    }

    public abstract Database db();

    @Value.Default
    public Duration tickInterval() {
        return Duration.ofSeconds(10L);
    }

    @Value.Default
    public Instant startupTime() {
        return Instant.now();
    }

    @Value.Default
    public MetricIntervals metrics() {
        List<Metric> metrics = Stream.of(IntradayLoggerMetrics.descriptors(), MemoryMetrics.descriptors(), GCMetrics.descriptors(), ProcMetrics.descriptors()).flatMap(Function.identity()).collect(Collectors.toList());
        List<Interval> intervals = Arrays.asList(Interval.T1m, Interval.T5m, Interval.T15m);
        return MetricIntervals.join(metrics, intervals);
    }

    public final StatsQueryResults execute() throws Exception {
        return this.toStatsQuery().execute();
    }

    public final StatsQuery toStatsQuery() throws Exception {
        DynamicTable startupTime = TableTools.newTable((ColumnHolder[])new ColumnHolder[]{TableTools.col((String)"StartupTime", (Object[])new DBDateTime[]{DBTimeUtils.millisToTime((long)this.startupTime().toEpochMilli())})});
        Table tt = this.db().timeTable(this.tickInterval().toNanos()).view(new String[]{"TTimestamp=Timestamp"}).lastBy();
        return ImmutableStatsQuery.builder().db(this.db()).ticking(tt).startupTime((Table)startupTime).metrics(this.metrics().asTable()).build();
    }
}

