/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.illumon.iris.db.tables.utils.DBDateTime;
import io.deephaven.plugins.monitoring.ImmutableSystemOutListenerKey;
import io.deephaven.plugins.monitoring.Interval;
import io.deephaven.plugins.monitoring.StatsQueryResultsDecorated;
import io.deephaven.plugins.monitoring.Unit;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import org.immutables.value.Value;

@Value.Immutable
public abstract class StatsQueryDenormalizedKVFileWriter
implements StatsQueryResultsDecorated.StatsQueryListener {
    public abstract Path path();

    @Value.Default
    public boolean toPascalCase() {
        return false;
    }

    @Value.Default
    public DateTimeFormatter dateFormatter() {
        return DateTimeFormatter.ISO_LOCAL_DATE;
    }

    @Value.Default
    public DateTimeFormatter timestampFormatter() {
        return DateTimeFormatter.ISO_INSTANT;
    }

    @Value.Default
    public ZoneId timestampZone() {
        return ZoneOffset.UTC;
    }

    @Value.Default
    public NumberFormat countFormat() {
        return new DecimalFormat("0");
    }

    @Value.Default
    public NumberFormat percentFormat() {
        DecimalFormat percentFormat = new DecimalFormat("0.#");
        percentFormat.setMultiplier(100);
        return percentFormat;
    }

    @Value.Default
    public NumberFormat bytesFormat() {
        return new DecimalFormat("0.#");
    }

    @Value.Default
    public BytesUnit bytesUnit() {
        return BytesUnit.STANDARD;
    }

    @Value.Default
    public String processIdKey() {
        return "ProcessId";
    }

    @Value.Default
    public String intervalKey() {
        return "Interval";
    }

    @Value.Default
    public IntervalFormat intervalFormat() {
        return IntervalFormat.STANDARD;
    }

    @Value.Default
    public String hostKey() {
        return "Host";
    }

    @Value.Default
    public String processNameKey() {
        return "ProcessName";
    }

    @Value.Default
    public String pqSerialKey() {
        return "PqSerial";
    }

    @Value.Default
    public String pqOwnerKey() {
        return "PqOwner";
    }

    @Value.Default
    public String pqNameKey() {
        return "PqName";
    }

    @Value.Default
    public String pqVersionKey() {
        return "PqVersion";
    }

    public final void deleteIfExists() throws IOException {
        Files.deleteIfExists(this.path());
    }

    @Override
    public final void handle(Collection<StatsQueryResultsDecorated.Row> rows) {
        LinkedHashMap<SystemOutListenerKey, List> map = new LinkedHashMap<SystemOutListenerKey, List>();
        for (StatsQueryResultsDecorated.Row row : rows) {
            map.computeIfAbsent(SystemOutListenerKey.of(row), k -> new ArrayList()).add(row);
        }
        ArrayList<String> lines = new ArrayList<String>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            lines.add(this.toString((SystemOutListenerKey)entry.getKey(), (List)entry.getValue()));
        }
        try {
            Files.write(this.path(), lines, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private String toString(SystemOutListenerKey key, List<StatsQueryResultsDecorated.Row> rows) {
        String basics = String.format("%s %s", this.dateFormatter().format(LocalDate.parse(key.date())), this.timestampFormatter().format(key.timestamp().getInstant().atZone(this.timestampZone())));
        StringBuilder sb = new StringBuilder(basics);
        StatsQueryDenormalizedKVFileWriter.append(sb, this.processIdKey(), key.processId());
        StatsQueryDenormalizedKVFileWriter.append(sb, this.intervalKey(), this.intervalFormat().toString(key.interval()));
        StatsQueryDenormalizedKVFileWriter.appendIf(sb, this.hostKey(), key.host());
        StatsQueryDenormalizedKVFileWriter.appendIf(sb, this.processNameKey(), key.processName());
        StatsQueryDenormalizedKVFileWriter.appendIf(sb, this.pqSerialKey(), key.pqSerial());
        StatsQueryDenormalizedKVFileWriter.appendIf(sb, this.pqOwnerKey(), key.pqOwner());
        StatsQueryDenormalizedKVFileWriter.appendIf(sb, this.pqNameKey(), key.pqName());
        StatsQueryDenormalizedKVFileWriter.appendIf(sb, this.pqVersionKey(), key.pqVersion());
        for (StatsQueryResultsDecorated.Row row : rows) {
            String name = this.rename(row.name());
            sb.append(" ").append(name).append("=").append(this.toString(row.unit(), row.value()));
        }
        return sb.toString();
    }

    private String rename(String name) {
        if (!this.toPascalCase()) {
            return name;
        }
        return StatsQueryDenormalizedKVFileWriter.toPascalCase(name, '-');
    }

    private static String toPascalCase(CharSequence cs, char delim) {
        int L = cs.length();
        StringBuilder sb = new StringBuilder(L);
        boolean convert = true;
        for (int i = 0; i < L; ++i) {
            char c = cs.charAt(i);
            if (delim == c) {
                convert = true;
                continue;
            }
            if (convert) {
                sb.append(Character.toUpperCase(c));
                convert = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String toString(Unit unit, double value) {
        switch (unit) {
            case COUNT_PER_MIN: 
            case PAGES: {
                return this.countFormat().format(value);
            }
            case CPU_PERC: 
            case TIME_PERCENT: {
                return this.percentFormat().format(value);
            }
            case BYTES: 
            case BYTES_PER_MIN: {
                return this.bytesFormat().format(this.bytesUnit().fromBytes(value));
            }
        }
        return Double.toString(value);
    }

    private static void appendIf(StringBuilder sb, String key, Optional<?> value) {
        if (value.isPresent()) {
            StatsQueryDenormalizedKVFileWriter.append(sb, key, value.get().toString());
        }
    }

    private static void append(StringBuilder sb, String key, String str) {
        if (StatsQueryDenormalizedKVFileWriter.containsWhitespace(str)) {
            str = '\"' + str + '\"';
        }
        sb.append(" ").append(key).append('=').append(str);
    }

    private static void appendIf(StringBuilder sb, String key, OptionalLong value) {
        if (value.isPresent()) {
            sb.append(" ").append(key).append("=").append(value.getAsLong());
        }
    }

    private static boolean containsWhitespace(CharSequence cs) {
        return cs.codePoints().anyMatch(Character::isWhitespace);
    }

    public static enum IntervalFormat {
        STANDARD{

            @Override
            public String toString(Interval interval) {
                return interval.metricsInterval();
            }
        }
        ,
        SECONDS{

            @Override
            public String toString(Interval interval) {
                return Integer.toString(interval.getNumberOf10s() * 10);
            }
        };


        public abstract String toString(Interval var1);
    }

    public static enum BytesUnit {
        STANDARD(1),
        KILO(1024),
        MEGA(0x100000),
        GIGA(0x40000000);

        private final int numBytes;

        private BytesUnit(int numBytes) {
            this.numBytes = numBytes;
        }

        public double fromBytes(long bytes) {
            return (double)bytes / (double)this.numBytes;
        }

        public double fromBytes(double bytes) {
            return bytes / (double)this.numBytes;
        }
    }

    @Value.Immutable
    static abstract class SystemOutListenerKey {
        SystemOutListenerKey() {
        }

        public static SystemOutListenerKey of(StatsQueryResultsDecorated.Row row) {
            return ImmutableSystemOutListenerKey.builder().date(row.date()).timestamp(row.timestamp()).processId(row.processId()).interval(row.interval()).host(row.host()).processName(row.processName()).pqSerial(row.pqSerial()).pqOwner(row.pqOwner()).pqName(row.pqName()).pqVersion(row.pqVersion()).build();
        }

        public abstract String date();

        public abstract DBDateTime timestamp();

        public abstract String processId();

        public abstract Interval interval();

        public abstract Optional<String> host();

        public abstract Optional<String> processName();

        public abstract OptionalLong pqSerial();

        public abstract Optional<String> pqOwner();

        public abstract Optional<String> pqName();

        public abstract OptionalLong pqVersion();
    }
}

