/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.illumon.dataobjects.ColumnDefinition;
import com.illumon.iris.db.tables.Table;
import com.illumon.iris.db.tables.TableDefinition;
import com.illumon.iris.db.tables.utils.DBDateTime;
import com.illumon.iris.db.v2.select.SelectColumn;
import com.illumon.iris.db.v2.select.SourceColumn;
import io.deephaven.plugins.monitoring.Helper;
import io.deephaven.plugins.monitoring.ImmutableProcessIdDecorationTable;
import io.deephaven.plugins.monitoring.ImmutableProcessIdInternalDecorationQuery;
import io.deephaven.plugins.monitoring.ImmutableStatsQueryResultsDecorated;
import io.deephaven.plugins.monitoring.Interval;
import io.deephaven.plugins.monitoring.MetricInterval;
import io.deephaven.plugins.monitoring.MetricIntervals;
import io.deephaven.plugins.monitoring.ProcessIdDecorationTable;
import io.deephaven.plugins.monitoring.ProcessInfoKeyDescriptor;
import io.deephaven.plugins.monitoring.StatsQuery;
import io.deephaven.plugins.monitoring.StatsQueryResultsDecorated;
import io.deephaven.plugins.monitoring.Unit;
import java.util.Arrays;
import org.immutables.value.Value;

@Value.Immutable
public abstract class StatsQueryResults {
    public static final ColumnDefinition<String> DATE_DEF = new ColumnDefinition("Date", String.class);
    public static final ColumnDefinition<DBDateTime> TIMESTAMP_DEF = new ColumnDefinition("Timestamp", DBDateTime.class);
    public static final ColumnDefinition<String> PROCESS_ID_DEF = new ColumnDefinition("ProcessId", String.class);
    public static final ColumnDefinition<String> NAME_DEF = new ColumnDefinition("Name", String.class);
    public static final ColumnDefinition<Interval> INTERVAL_DEF = new ColumnDefinition("Interval", Interval.class);
    public static final ColumnDefinition<Unit> UNIT_DEF = new ColumnDefinition("Unit", Unit.class);
    public static final ColumnDefinition<Double> VALUE_DEF = new ColumnDefinition("Value", Double.TYPE);
    public static final TableDefinition EXPECTED_TYPE = new TableDefinition(Arrays.asList(DATE_DEF, TIMESTAMP_DEF, PROCESS_ID_DEF, NAME_DEF, INTERVAL_DEF, UNIT_DEF, VALUE_DEF));

    public abstract StatsQuery query();

    public abstract Table metrics();

    public final StatsQueryResultsDecorated decorated(int numDays) {
        ProcessIdDecorationTable decorations = ImmutableProcessIdInternalDecorationQuery.builder().db(this.query().db()).addKeys(ProcessInfoKeyDescriptor.hostname(), ProcessInfoKeyDescriptor.processName(), ProcessInfoKeyDescriptor.pqSerial(), ProcessInfoKeyDescriptor.pqOwner(), ProcessInfoKeyDescriptor.pqName(), ProcessInfoKeyDescriptor.pqVersion()).numDays(numDays).build().execute();
        Table decorated = this.query().ticking().snapshotIncremental(decorations.decorateOnto(this.metrics()), new String[0]).dropColumns(new String[]{"TTimestamp"});
        return ImmutableStatsQueryResultsDecorated.builder().query(this.query()).metrics(decorated).build();
    }

    public final ProcessIdDecorationTable asProcessIdDecorator(MetricIntervals metricIntervals) {
        SourceColumn processIdSourceColumn = new SourceColumn(PROCESS_ID_DEF.getName());
        Table joined = this.metrics().selectDistinct(new SelectColumn[]{processIdSourceColumn});
        for (MetricInterval metricInterval : metricIntervals.metrics()) {
            String newColumnName = metricInterval.metric().rename().replace("-", "_") + "_" + metricInterval.interval().metricsInterval();
            Table singleValue = metricInterval.interval().filter(metricInterval.metric().filterColumnByRename(NAME_DEF.getName(), this.metrics())).view(new SelectColumn[]{processIdSourceColumn, new SourceColumn(VALUE_DEF.getName(), newColumnName)});
            joined = joined.naturalJoin(singleValue, PROCESS_ID_DEF.getName());
        }
        return ImmutableProcessIdDecorationTable.of(joined);
    }

    @Value.Check
    final void checkDefinition() {
        Helper.checkDefinition(EXPECTED_TYPE, this.metrics().getDefinition());
    }
}

