/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.illumon.dataobjects.ColumnDefinition;
import com.illumon.iris.db.tables.Table;
import com.illumon.iris.db.tables.TableDefinition;
import com.illumon.iris.db.tables.utils.DBDateTime;
import com.illumon.iris.db.v2.DynamicTable;
import com.illumon.iris.db.v2.InstrumentedShiftAwareListenerAdapter;
import com.illumon.iris.db.v2.ShiftAwareListener;
import com.illumon.iris.db.v2.sources.ColumnSource;
import com.illumon.iris.db.v2.utils.LongAbortableConsumer;
import com.illumon.iris.libs.primitives.LongPrimitives;
import io.deephaven.plugins.monitoring.Helper;
import io.deephaven.plugins.monitoring.Interval;
import io.deephaven.plugins.monitoring.StatsQuery;
import io.deephaven.plugins.monitoring.StatsQueryResults;
import io.deephaven.plugins.monitoring.Unit;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import org.immutables.value.Value;

@Value.Immutable
public abstract class StatsQueryResultsDecorated {
    public static final ColumnDefinition<String> HOST_DEF = new ColumnDefinition("Host", String.class);
    public static final ColumnDefinition<String> PROCESS_NAME_DEF = new ColumnDefinition("ProcessName", String.class);
    public static final ColumnDefinition<Long> PQ_SERIAL_DEF = new ColumnDefinition("PqSerial", Long.TYPE);
    public static final ColumnDefinition<String> PQ_OWNER_DEF = new ColumnDefinition("PqOwner", String.class);
    public static final ColumnDefinition<String> PQ_NAME_DEF = new ColumnDefinition("PqName", String.class);
    public static final ColumnDefinition<Long> PQ_VERSION_DEF = new ColumnDefinition("PqVersion", Long.TYPE);
    public static final TableDefinition EXPECTED_TYPE = new TableDefinition(Arrays.asList(StatsQueryResults.DATE_DEF, StatsQueryResults.TIMESTAMP_DEF, StatsQueryResults.PROCESS_ID_DEF, StatsQueryResults.NAME_DEF, StatsQueryResults.INTERVAL_DEF, StatsQueryResults.UNIT_DEF, StatsQueryResults.VALUE_DEF, HOST_DEF, PROCESS_NAME_DEF, PQ_SERIAL_DEF, PQ_OWNER_DEF, PQ_NAME_DEF, PQ_VERSION_DEF));

    public abstract StatsQuery query();

    public abstract Table metrics();

    public final Closeable installListener(StatsQueryListener listener) {
        ListenerAdapter adapter = new ListenerAdapter(listener);
        adapter.init();
        return adapter;
    }

    @Value.Check
    final void checkDefinition() {
        Helper.checkDefinition(EXPECTED_TYPE, this.metrics().getDefinition());
    }

    final class RowLazyPostShift
    implements Row {
        private final long postshiftIx;

        private RowLazyPostShift(long postshiftIx) {
            this.postshiftIx = postshiftIx;
        }

        @Override
        public String date() {
            return this.get(StatsQueryResults.DATE_DEF);
        }

        @Override
        public DBDateTime timestamp() {
            return this.get(StatsQueryResults.TIMESTAMP_DEF);
        }

        @Override
        public String processId() {
            return this.get(StatsQueryResults.PROCESS_ID_DEF);
        }

        @Override
        public String name() {
            return this.get(StatsQueryResults.NAME_DEF);
        }

        @Override
        public Interval interval() {
            return this.get(StatsQueryResults.INTERVAL_DEF);
        }

        @Override
        public Unit unit() {
            return this.get(StatsQueryResults.UNIT_DEF);
        }

        @Override
        public double value() {
            return this.source(StatsQueryResults.VALUE_DEF).getDouble(this.postshiftIx);
        }

        @Override
        public Optional<String> host() {
            return this.oget(HOST_DEF);
        }

        @Override
        public Optional<String> processName() {
            return this.oget(PROCESS_NAME_DEF);
        }

        @Override
        public OptionalLong pqSerial() {
            long x = this.source(PQ_SERIAL_DEF).getLong(this.postshiftIx);
            return LongPrimitives.isNull((long)x) ? OptionalLong.empty() : OptionalLong.of(x);
        }

        @Override
        public Optional<String> pqOwner() {
            return this.oget(PQ_OWNER_DEF);
        }

        @Override
        public Optional<String> pqName() {
            return this.oget(PQ_NAME_DEF);
        }

        @Override
        public OptionalLong pqVersion() {
            long x = this.source(PQ_VERSION_DEF).getLong(this.postshiftIx);
            return LongPrimitives.isNull((long)x) ? OptionalLong.empty() : OptionalLong.of(x);
        }

        private <T> Optional<T> oget(ColumnDefinition<T> def) {
            return Optional.ofNullable(this.get(def));
        }

        private <T> T get(ColumnDefinition<T> def) {
            return (T)this.source(def).get(this.postshiftIx);
        }

        private <T> ColumnSource<T> source(ColumnDefinition<T> def) {
            return StatsQueryResultsDecorated.this.metrics().getColumnSource(def.getName(), def.getDataType());
        }
    }

    private class RowsBuilder
    implements LongAbortableConsumer {
        private final List<Row> rows;

        public RowsBuilder(int capacity) {
            this.rows = new ArrayList<Row>(capacity);
        }

        public boolean accept(long postshiftIx) {
            this.rows.add(new RowLazyPostShift(postshiftIx));
            return true;
        }
    }

    class ListenerAdapter
    extends InstrumentedShiftAwareListenerAdapter
    implements Closeable {
        private static final long serialVersionUID = 1231561346160451408L;
        private final StatsQueryListener listener;

        ListenerAdapter(StatsQueryListener listener) {
            super((DynamicTable)StatsQueryResultsDecorated.this.metrics());
            this.listener = Objects.requireNonNull(listener);
        }

        final void init() {
            this.source.listenForUpdates((ShiftAwareListener)this);
        }

        public final void remove() {
            this.source.removeUpdateListener((ShiftAwareListener)this);
        }

        public void onUpdate(ShiftAwareListener.Update upstream) {
            RowsBuilder builder = new RowsBuilder(Math.toIntExact(upstream.added.size() + upstream.modified.size()));
            upstream.added.forEachLong((LongAbortableConsumer)builder);
            upstream.modified.forEachLong((LongAbortableConsumer)builder);
            this.listener.handle(builder.rows);
        }

        @Override
        public void close() {
            this.remove();
        }
    }

    public static interface StatsQueryListener {
        public void handle(Collection<Row> var1);
    }

    public static interface Row {
        public String date();

        public DBDateTime timestamp();

        public String processId();

        public Interval interval();

        public Unit unit();

        public String name();

        public double value();

        public Optional<String> host();

        public Optional<String> processName();

        public OptionalLong pqSerial();

        public Optional<String> pqOwner();

        public Optional<String> pqName();

        public OptionalLong pqVersion();
    }
}

