package io.dekorate.docker.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DockerBuildConfigBuilder extends DockerBuildConfigFluentImpl<DockerBuildConfigBuilder> implements VisitableBuilder<DockerBuildConfig,DockerBuildConfigBuilder>{

    DockerBuildConfigFluent<?> fluent;
    Boolean validationEnabled;

    public DockerBuildConfigBuilder(){
            this(true);
    }
    public DockerBuildConfigBuilder(Boolean validationEnabled){
            this(new DockerBuildConfig(), validationEnabled);
    }
    public DockerBuildConfigBuilder(DockerBuildConfigFluent<?> fluent){
            this(fluent, true);
    }
    public DockerBuildConfigBuilder(DockerBuildConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DockerBuildConfig(), validationEnabled);
    }
    public DockerBuildConfigBuilder(DockerBuildConfigFluent<?> fluent,DockerBuildConfig instance){
            this(fluent, instance, true);
    }
    public DockerBuildConfigBuilder(DockerBuildConfigFluent<?> fluent,DockerBuildConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withProject(instance.getProject()); 
            fluent.withAttributes(instance.getAttributes()); 
            fluent.withRegistry(instance.getRegistry()); 
            fluent.withGroup(instance.getGroup()); 
            fluent.withName(instance.getName()); 
            fluent.withVersion(instance.getVersion()); 
            fluent.withImage(instance.getImage()); 
            fluent.withDockerFile(instance.getDockerFile()); 
            fluent.withAutoBuildEnabled(instance.isAutoBuildEnabled()); 
            fluent.withAutoPushEnabled(instance.isAutoPushEnabled()); 
            fluent.withEnabled(instance.isEnabled()); 
            fluent.withAutoDeployEnabled(instance.isAutoDeployEnabled()); 
            this.validationEnabled = validationEnabled; 
    }
    public DockerBuildConfigBuilder(DockerBuildConfig instance){
            this(instance,true);
    }
    public DockerBuildConfigBuilder(DockerBuildConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withProject(instance.getProject()); 
            this.withAttributes(instance.getAttributes()); 
            this.withRegistry(instance.getRegistry()); 
            this.withGroup(instance.getGroup()); 
            this.withName(instance.getName()); 
            this.withVersion(instance.getVersion()); 
            this.withImage(instance.getImage()); 
            this.withDockerFile(instance.getDockerFile()); 
            this.withAutoBuildEnabled(instance.isAutoBuildEnabled()); 
            this.withAutoPushEnabled(instance.isAutoPushEnabled()); 
            this.withEnabled(instance.isEnabled()); 
            this.withAutoDeployEnabled(instance.isAutoDeployEnabled()); 
            this.validationEnabled = validationEnabled; 
    }

    public EditableDockerBuildConfig build(){
            EditableDockerBuildConfig buildable = new EditableDockerBuildConfig(fluent.getProject(),fluent.getAttributes(),fluent.getRegistry(),fluent.getGroup(),fluent.getName(),fluent.getVersion(),fluent.getImage(),fluent.getDockerFile(),fluent.isAutoBuildEnabled(),fluent.isAutoPushEnabled(),fluent.isEnabled(),fluent.isAutoDeployEnabled());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DockerBuildConfigBuilder that = (DockerBuildConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
