package io.dekorate.docker.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.ImageConfiguration;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.fabric8.kubernetes.api.builder") public class DockerBuildConfig extends ImageConfiguration {

    private Boolean enabled;
    private Boolean autoDeployEnabled;

    public DockerBuildConfig() {
    }

    public DockerBuildConfig(Project project,Map<ConfigKey,Object> attributes,String registry,String group,String name,String version,String image,String dockerFile,Boolean autoBuildEnabled,Boolean autoPushEnabled,Boolean enabled,Boolean autoDeployEnabled) {
        super(project, attributes, registry, group, name, version, image, dockerFile, autoBuildEnabled, autoPushEnabled);
        this.enabled = enabled;
        this.autoDeployEnabled = autoDeployEnabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled != null &&  this.enabled;
    }

    public Boolean getAutoDeployEnabled() {
        return this.autoDeployEnabled;
    }

    public boolean isAutoDeployEnabled() {
        return this.autoDeployEnabled != null &&  this.autoDeployEnabled;
    }

    public static DockerBuildConfigBuilder newDockerBuildConfigBuilder() {
        return new io.dekorate.docker.config.DockerBuildConfigBuilder();
    }

    public static DockerBuildConfigBuilder newDockerBuildConfigBuilderFromDefaults() {
        return new io.dekorate.docker.config.DockerBuildConfigBuilder().withEnabled(true).withDockerFile("Dockerfile").withAutoPushEnabled(false).withAutoBuildEnabled(false).withAutoDeployEnabled(false);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DockerBuildConfig that = (DockerBuildConfig) o;
        if (enabled != null ? !enabled.equals(that.enabled) :that.enabled != null) return false;
        if (autoDeployEnabled != null ? !autoDeployEnabled.equals(that.autoDeployEnabled) :that.autoDeployEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(enabled,  autoDeployEnabled,  super.hashCode());
    }

}
