/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.generator;

import io.dekorate.Generator;
import io.dekorate.Session;
import io.dekorate.SessionListener;
import io.dekorate.WithProject;
import io.dekorate.config.AnnotationConfiguration;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.config.PropertyConfiguration;
import io.dekorate.kubernetes.adapter.KubernetesConfigAdapter;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.config.KubernetesConfigBuilder;
import io.dekorate.kubernetes.configurator.ApplyBuildToImageConfiguration;
import io.dekorate.kubernetes.configurator.ApplyDeployToApplicationConfiguration;
import io.dekorate.kubernetes.configurator.ApplyImagePullSecretConfiguration;
import io.dekorate.kubernetes.handler.KubernetesHandler;
import io.dekorate.kubernetes.listener.KubernetesSessionListener;
import io.dekorate.project.ApplyProjectInfo;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import java.util.Map;

public interface KubernetesApplicationGenerator
extends Generator,
WithProject {
    public static final String KUBERNETES = "kubernetes";
    public static final KubernetesSessionListener LISTENER = new KubernetesSessionListener();

    default public String getKey() {
        return KUBERNETES;
    }

    default public Class<? extends Configuration> getConfigType() {
        return KubernetesConfig.class;
    }

    default public void addAnnotationConfiguration(Map map) {
        this.add((ConfigurationSupplier<KubernetesConfig>)new AnnotationConfiguration((VisitableBuilder)((KubernetesConfigBuilder)((KubernetesConfigBuilder)((KubernetesConfigBuilder)KubernetesConfigAdapter.newBuilder(this.propertiesMap(map, KubernetesConfig.class)).accept((Visitor)new ApplyBuildToImageConfiguration())).accept((Visitor)new ApplyImagePullSecretConfiguration())).accept((Visitor)new ApplyDeployToApplicationConfiguration())).accept((Visitor)new ApplyProjectInfo(this.getProject()))));
    }

    default public void addPropertyConfiguration(Map map) {
        this.add((ConfigurationSupplier<KubernetesConfig>)new PropertyConfiguration((VisitableBuilder)((KubernetesConfigBuilder)((KubernetesConfigBuilder)((KubernetesConfigBuilder)KubernetesConfigAdapter.newBuilder(this.propertiesMap(map, KubernetesConfig.class)).accept((Visitor)new ApplyBuildToImageConfiguration())).accept((Visitor)new ApplyImagePullSecretConfiguration())).accept((Visitor)new ApplyDeployToApplicationConfiguration())).accept((Visitor)new ApplyProjectInfo(this.getProject()))));
    }

    default public void add(ConfigurationSupplier<KubernetesConfig> config) {
        Session session = this.getSession();
        session.configurators().add(config);
        session.resources().groups().putIfAbsent(KUBERNETES, new KubernetesListBuilder());
        session.handlers().add(new KubernetesHandler(session.resources(), session.configurators()));
        session.addListener((SessionListener)LISTENER);
    }
}

