/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.adapter;

import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.AddLivenessProbeDecorator;
import io.dekorate.kubernetes.decorator.AddMountDecorator;
import io.dekorate.kubernetes.decorator.AddPortDecorator;
import io.dekorate.kubernetes.decorator.AddReadinessProbeDecorator;
import io.dekorate.kubernetes.decorator.ApplyImagePullPolicyDecorator;
import io.dekorate.kubernetes.decorator.ApplyLimitsCpuDecorator;
import io.dekorate.kubernetes.decorator.ApplyLimitsMemoryDecorator;
import io.dekorate.kubernetes.decorator.ApplyRequestsCpuDecorator;
import io.dekorate.kubernetes.decorator.ApplyRequestsMemoryDecorator;
import io.dekorate.utils.Probes;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;

public class ContainerAdapter {
    public static void applyContainerToBuilder(ContainerBuilder builder, io.dekorate.kubernetes.config.Container container) {
        String name = container.getName();
        ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)builder.withName(container.getName())).withImage(container.getImage())).withCommand(container.getCommand())).withArgs(container.getArguments());
        for (Env env : container.getEnvVars()) {
            builder.accept(new Visitor[]{new AddEnvVarDecorator(env)});
        }
        for (Port port : container.getPorts()) {
            builder.accept(new Visitor[]{new AddPortDecorator(port)});
        }
        for (Mount mount : container.getMounts()) {
            builder.accept(new Visitor[]{new AddMountDecorator(mount)});
        }
        builder.accept(new Visitor[]{new ApplyImagePullPolicyDecorator(container.getImagePullPolicy())});
        if (Probes.isConfigured((Probe)container.getLivenessProbe())) {
            builder.accept(new Visitor[]{new AddLivenessProbeDecorator(name, container.getLivenessProbe())});
        }
        if (Probes.isConfigured((Probe)container.getReadinessProbe())) {
            builder.accept(new Visitor[]{new AddReadinessProbeDecorator(name, container.getReadinessProbe())});
        }
        if (Strings.isNotNullOrEmpty((String)container.getLimitResources().getCpu())) {
            builder.accept(new Visitor[]{new ApplyLimitsCpuDecorator(name, container.getLimitResources().getCpu())});
        }
        if (Strings.isNotNullOrEmpty((String)container.getLimitResources().getMemory())) {
            builder.accept(new Visitor[]{new ApplyLimitsMemoryDecorator(name, container.getLimitResources().getMemory())});
        }
        if (Strings.isNotNullOrEmpty((String)container.getRequestResources().getCpu())) {
            builder.accept(new Visitor[]{new ApplyRequestsCpuDecorator(name, container.getRequestResources().getCpu())});
        }
        if (Strings.isNotNullOrEmpty((String)container.getRequestResources().getMemory())) {
            builder.accept(new Visitor[]{new ApplyRequestsMemoryDecorator(name, container.getRequestResources().getMemory())});
        }
    }

    public static Container adapt(io.dekorate.kubernetes.config.Container container) {
        ContainerBuilder builder = new ContainerBuilder();
        ContainerAdapter.applyContainerToBuilder(builder, container);
        return builder.build();
    }
}

