/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.EditableMount;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.MountFluent;
import io.dekorate.kubernetes.config.MountFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Objects;

public class MountBuilder
extends MountFluentImpl<MountBuilder>
implements VisitableBuilder<Mount, MountBuilder> {
    MountFluent<?> fluent;
    Boolean validationEnabled;

    public MountBuilder() {
        this(true);
    }

    public MountBuilder(Boolean validationEnabled) {
        this(new Mount(), validationEnabled);
    }

    public MountBuilder(MountFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public MountBuilder(MountFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Mount(), validationEnabled);
    }

    public MountBuilder(MountFluent<?> fluent, Mount instance) {
        this(fluent, instance, true);
    }

    public MountBuilder(MountFluent<?> fluent, Mount instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withPath(instance.getPath());
        fluent.withSubPath(instance.getSubPath());
        fluent.withReadOnly(instance.isReadOnly());
        this.validationEnabled = validationEnabled;
    }

    public MountBuilder(Mount instance) {
        this(instance, (Boolean)true);
    }

    public MountBuilder(Mount instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withPath(instance.getPath());
        this.withSubPath(instance.getSubPath());
        this.withReadOnly(instance.isReadOnly());
        this.validationEnabled = validationEnabled;
    }

    public EditableMount build() {
        EditableMount buildable = new EditableMount(this.fluent.getName(), this.fluent.getPath(), this.fluent.getSubPath(), this.fluent.isReadOnly());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MountBuilder that = (MountBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

