/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.configurator;

import io.dekorate.kubernetes.config.BaseConfigFluent;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortBuilder;
import io.dekorate.utils.Ports;
import io.dekorate.utils.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public class ApplyPort
extends Configurator<BaseConfigFluent<?>> {
    private static final String FALLBACK_PORT_NAME = "http";
    private static final String DEFAULT_PATH = "/";
    private final Port port;
    private final List<String> names;

    public ApplyPort(Port port, List<String> names) {
        this.port = port;
        this.names = names;
    }

    public ApplyPort(Port port, String ... names) {
        this(port, Arrays.asList(names));
    }

    public void visit(BaseConfigFluent<?> config) {
        Predicate<PortBuilder> predicate = p -> this.names.contains(p.getName());
        if (config.hasMatchingPort(predicate).booleanValue()) {
            if (Strings.isNotNullOrEmpty((String)this.port.getPath()) && !DEFAULT_PATH.equals(this.port.getPath())) {
                ((BaseConfigFluent.PortsNested)config.editMatchingPort(predicate).withPath(this.port.getPath())).endPort();
            }
            if (this.port.getContainerPort() != 0) {
                ((BaseConfigFluent.PortsNested)config.editMatchingPort(predicate).withContainerPort(this.port.getContainerPort())).endPort();
            }
            if (this.port.getHostPort() != 0) {
                ((BaseConfigFluent.PortsNested)config.editMatchingPort(predicate).withHostPort(this.port.getHostPort())).endPort();
            } else if (Ports.isWebPort((Port)this.port)) {
                ((BaseConfigFluent.PortsNested)config.editMatchingPort(predicate).withHostPort(80)).endPort();
            }
        } else {
            String name = this.names.size() > 0 ? this.names.get(0) : FALLBACK_PORT_NAME;
            ((BaseConfigFluent.PortsNested)((BaseConfigFluent.PortsNested)config.addNewPortLike(this.port).withName(name)).withContainerPort(this.port.getContainerPort())).endPort();
        }
    }
}

