/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.configurator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.BaseConfigFluent;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.PortBuilder;
import java.util.function.Predicate;

@Description(value="Sets the path for the matching port.")
public class SetPortPath
extends Configurator<BaseConfigFluent<?>> {
    private final Predicate<PortBuilder> predicate = p -> p.getName().equals(name);
    private final String path;

    public SetPortPath(String name, String path) {
        this.path = path;
    }

    public void visit(BaseConfigFluent<?> config) {
        if (config.hasMatchingPort(this.predicate).booleanValue()) {
            config.editMatchingPort(this.predicate).withPath(this.path);
        }
    }
}

