/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.utils.Ports;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ExecAction;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.TCPSocketAction;
import java.util.Arrays;
import java.util.Collections;

public abstract class AbstractAddProbeDecorator
extends ApplicationContainerDecorator<ContainerFluent<?>> {
    protected final Probe probe;

    protected abstract void doCreateProbe(ContainerFluent<?> var1, Actions var2);

    public AbstractAddProbeDecorator(String containerName, Probe probe) {
        super(null, containerName);
        this.probe = probe;
    }

    public AbstractAddProbeDecorator(String deploymentName, String containerName, Probe probe) {
        super(deploymentName, containerName);
        this.probe = probe;
    }

    @Override
    public void andThenVisit(ContainerFluent<?> container) {
        HTTPGetAction httpGetAction;
        if (this.probe == null) {
            return;
        }
        ExecAction execAction = this.execAction(this.probe);
        TCPSocketAction tcpSocketAction = this.tcpSocketAction(this.probe);
        boolean defaultToHttpGetAction = execAction == null && tcpSocketAction == null;
        HTTPGetAction hTTPGetAction = httpGetAction = defaultToHttpGetAction ? this.httpGetAction(this.probe, container) : null;
        if (defaultToHttpGetAction && httpGetAction == null) {
            return;
        }
        this.doCreateProbe(container, new Actions(execAction, tcpSocketAction, httpGetAction));
    }

    private ExecAction execAction(Probe probe) {
        if (Strings.isNullOrEmpty((String)probe.getExecAction())) {
            return null;
        }
        return new ExecAction(Arrays.asList(probe.getExecAction().split(" ")));
    }

    private HTTPGetAction httpGetAction(Probe probe, ContainerFluent<?> container) {
        if (!container.hasPorts().booleanValue()) {
            return new HTTPGetAction(null, Collections.emptyList(), probe.getHttpActionPath(), new IntOrString(Integer.valueOf(8080)), "HTTP");
        }
        return new HTTPGetAction(null, Collections.emptyList(), probe.getHttpActionPath(), new IntOrString(((ContainerPort)Ports.getHttpPort(container).get()).getContainerPort()), "HTTP");
    }

    private TCPSocketAction tcpSocketAction(Probe probe) {
        if (Strings.isNullOrEmpty((String)probe.getTcpSocketAction())) {
            return null;
        }
        String[] parts = probe.getTcpSocketAction().split(":");
        if (parts.length != 2) {
            throw new RuntimeException("Invalid format for tcp socket action! Expected: <host>:<port>. Found:" + probe.getTcpSocketAction() + ".");
        }
        return new TCPSocketAction(parts[0], new IntOrString(parts[1]));
    }

    protected static class Actions {
        protected final ExecAction execAction;
        protected final TCPSocketAction tcpSocketAction;
        protected final HTTPGetAction httpGetAction;

        protected Actions(ExecAction execAction, TCPSocketAction tcpSocketAction, HTTPGetAction httpGetAction) {
            this.execAction = execAction;
            this.tcpSocketAction = tcpSocketAction;
            this.httpGetAction = httpGetAction;
        }
    }
}

