/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressRuleValueFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRuleBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressSpecBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressSpecFluent;
import java.util.function.Predicate;

public class AddIngressRuleDecorator
extends NamedResourceDecorator<IngressSpecBuilder> {
    private final String host;
    private final Port port;

    public AddIngressRuleDecorator(String name, String host, Port port) {
        super(name);
        this.host = host;
        this.port = port;
    }

    @Override
    public void andThenVisit(IngressSpecBuilder spec, ObjectMeta meta) {
        Predicate<IngressRuleBuilder> matchingHost = r -> r.getHost().equals(this.host);
        if (!spec.hasMatchingRule(matchingHost).booleanValue()) {
            ((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((IngressBackendFluent.ServiceNested)((IngressServiceBackendFluent.PortNested)((IngressServiceBackendFluent.PortNested)((IngressBackendFluent.ServiceNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressRuleValueFluent.PathsNested)((IngressSpecFluent.RulesNested)spec.addNewRule().withHost(this.host)).withNewHttp().addNewPath().withPathType("Prefix")).withPath(this.port.getPath())).withNewBackend().withNewService().withName(this.name)).withNewPort().withName(this.port.getName())).withNumber(Strings.isNullOrEmpty((String)this.port.getName()) ? Integer.valueOf(this.port.getHostPort()) : null)).endPort()).endService()).endBackend()).endPath()).endHttp()).endRule();
        } else {
            spec.accept(new Visitor[]{new HostVisitor(meta)});
        }
    }

    private class PathVisitor
    extends TypedVisitor<HTTPIngressPathBuilder> {
        private final ObjectMeta meta;

        public PathVisitor(ObjectMeta meta) {
            this.meta = meta;
        }

        public void visit(HTTPIngressPathBuilder path) {
            ((HTTPIngressPathFluent.BackendNested)((IngressBackendFluent.ServiceNested)((IngressServiceBackendFluent.PortNested)((IngressServiceBackendFluent.PortNested)((IngressBackendFluent.ServiceNested)path.withNewBackend().withNewService().withName(AddIngressRuleDecorator.this.name)).withNewPort().withName(AddIngressRuleDecorator.this.port.getName())).withNumber(Strings.isNullOrEmpty((String)AddIngressRuleDecorator.this.port.getName()) ? Integer.valueOf(AddIngressRuleDecorator.this.port.getHostPort()) : null)).endPort()).endService()).endBackend();
        }
    }

    private class HostVisitor
    extends TypedVisitor<IngressRuleBuilder> {
        private final ObjectMeta meta;

        public HostVisitor(ObjectMeta meta) {
            this.meta = meta;
        }

        public void visit(IngressRuleBuilder rule) {
            Predicate<HTTPIngressPathBuilder> mathcingPath = r -> r.getPath().equals(AddIngressRuleDecorator.this.port.getPath());
            if (rule.getHost().equals(AddIngressRuleDecorator.this.host)) {
                if (!rule.editOrNewHttp().hasMatchingPath(mathcingPath).booleanValue()) {
                    ((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((IngressBackendFluent.ServiceNested)((IngressServiceBackendFluent.PortNested)((IngressServiceBackendFluent.PortNested)((IngressBackendFluent.ServiceNested)rule.editHttp().addNewPath().withNewBackend().withNewService().withName(AddIngressRuleDecorator.this.name)).withNewPort().withName(AddIngressRuleDecorator.this.port.getName())).withNumber(Strings.isNullOrEmpty((String)AddIngressRuleDecorator.this.port.getName()) ? Integer.valueOf(AddIngressRuleDecorator.this.port.getHostPort()) : null)).endPort()).endService()).endBackend()).endPath()).endHttp();
                } else {
                    rule.accept(new Visitor[]{new PathVisitor(this.meta)});
                }
            }
        }
    }
}

