/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.WithProject;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.kubernetes.decorator.RemoveLabelDecorator;
import io.dekorate.project.Project;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

@Description(value="Add a vcs url label to the all metadata.")
public class AddVcsUrlAnnotationDecorator
extends NamedResourceDecorator<ObjectMetaBuilder>
implements WithProject {
    private final String annotationKey;

    public AddVcsUrlAnnotationDecorator() {
        this(ANY);
    }

    public AddVcsUrlAnnotationDecorator(String name) {
        this(name, "app.dekorate.io/vcs-url");
    }

    public AddVcsUrlAnnotationDecorator(String name, String annotationKey) {
        super(name);
        this.annotationKey = annotationKey;
    }

    @Override
    public void andThenVisit(ObjectMetaBuilder builder, ObjectMeta resourceMeta) {
        boolean hasVcsUrl;
        Project p = this.getProject();
        boolean bl = hasVcsUrl = p.getScmInfo() != null && p.getScmInfo().getUrl() != null;
        if (hasVcsUrl) {
            builder.addToAnnotations(this.annotationKey, this.getProject().getScmInfo().getUrl());
        }
    }

    public String getAnnotationKey() {
        return this.annotationKey;
    }

    @Override
    public Class<? extends Decorator>[] before() {
        return new Class[]{RemoveLabelDecorator.class};
    }

    public int hashCode() {
        int prime = 31;
        int result = 1 + this.getClass().hashCode();
        result = 31 * result + (this.annotationKey == null ? 0 : this.annotationKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddVcsUrlAnnotationDecorator other = (AddVcsUrlAnnotationDecorator)obj;
        return !(this.annotationKey == null ? other.annotationKey != null : !this.annotationKey.equals(other.annotationKey));
    }
}

