/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.IngressBuilder;
import io.dekorate.kubernetes.config.IngressRule;
import java.util.Objects;

public class Ingress {
    private String host;
    private String ingressClassName;
    private String targetPort;
    private Boolean expose;
    private String tlsSecretName;
    private String[] tlsHosts = new String[0];
    private IngressRule[] rules = new IngressRule[0];

    public Ingress() {
    }

    public Ingress(String host, String ingressClassName, String targetPort, Boolean expose, String tlsSecretName, String[] tlsHosts, IngressRule[] rules) {
        this.host = host;
        this.ingressClassName = ingressClassName;
        this.targetPort = targetPort;
        this.expose = expose;
        this.tlsSecretName = tlsSecretName;
        this.tlsHosts = tlsHosts != null ? tlsHosts : new String[]{};
        this.rules = rules != null ? rules : new IngressRule[]{};
    }

    public String getHost() {
        return this.host;
    }

    public String getIngressClassName() {
        return this.ingressClassName;
    }

    public String getTargetPort() {
        return this.targetPort;
    }

    public Boolean getExpose() {
        return this.expose;
    }

    public boolean isExpose() {
        return this.expose != null && this.expose != false;
    }

    public String getTlsSecretName() {
        return this.tlsSecretName;
    }

    public String[] getTlsHosts() {
        return this.tlsHosts;
    }

    public IngressRule[] getRules() {
        return this.rules;
    }

    public static IngressBuilder newBuilder() {
        return new IngressBuilder();
    }

    public static IngressBuilder newBuilderFromDefaults() {
        return (IngressBuilder)((Object)((IngressBuilder)((Object)new IngressBuilder().withTargetPort("http"))).withExpose(false));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Ingress that = (Ingress)o;
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.ingressClassName, that.ingressClassName)) {
            return false;
        }
        if (!Objects.equals(this.targetPort, that.targetPort)) {
            return false;
        }
        if (!Objects.equals(this.expose, that.expose)) {
            return false;
        }
        if (!Objects.equals(this.tlsSecretName, that.tlsSecretName)) {
            return false;
        }
        if (!Objects.equals(this.tlsHosts, that.tlsHosts)) {
            return false;
        }
        return Objects.equals(this.rules, that.rules);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.ingressClassName, this.targetPort, this.expose, this.tlsSecretName, this.tlsHosts, this.rules, super.hashCode());
    }
}

