/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.annotation.AccessMode;
import io.dekorate.kubernetes.config.ApplicationConfigurationFluent;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.LabelBuilder;
import io.dekorate.kubernetes.config.LabelFluent;
import io.dekorate.kubernetes.config.PersistentVolumeClaimConfig;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PersistentVolumeClaimConfigFluent<A extends PersistentVolumeClaimConfigFluent<A>>
extends ApplicationConfigurationFluent<A> {
    private int size;
    private String unit;
    private String storageClass;
    private AccessMode accessMode;
    private ArrayList<LabelBuilder> matchLabels = new ArrayList();

    public PersistentVolumeClaimConfigFluent() {
    }

    public PersistentVolumeClaimConfigFluent(PersistentVolumeClaimConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PersistentVolumeClaimConfig instance) {
        PersistentVolumeClaimConfig persistentVolumeClaimConfig = instance = instance != null ? instance : new PersistentVolumeClaimConfig();
        if (instance != null) {
            this.withProject(instance.getProject());
            this.withAttributes(instance.getAttributes());
            this.withPartOf(instance.getPartOf());
            this.withName(instance.getName());
            this.withVersion(instance.getVersion());
            this.withSize(instance.getSize());
            this.withUnit(instance.getUnit());
            this.withStorageClass(instance.getStorageClass());
            this.withAccessMode(instance.getAccessMode());
            this.withMatchLabels(instance.getMatchLabels());
        }
    }

    public int getSize() {
        return this.size;
    }

    public A withSize(int size) {
        this.size = size;
        return (A)((Object)this);
    }

    public boolean hasSize() {
        return true;
    }

    public String getUnit() {
        return this.unit;
    }

    public A withUnit(String unit) {
        this.unit = unit;
        return (A)((Object)this);
    }

    public boolean hasUnit() {
        return this.unit != null;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public A withStorageClass(String storageClass) {
        this.storageClass = storageClass;
        return (A)((Object)this);
    }

    public boolean hasStorageClass() {
        return this.storageClass != null;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public A withAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
        return (A)((Object)this);
    }

    public boolean hasAccessMode() {
        return this.accessMode != null;
    }

    public A withMatchLabels(Label ... matchLabels) {
        if (this.matchLabels != null) {
            this.matchLabels.clear();
            this._visitables.remove((Object)"matchLabels");
        }
        if (matchLabels != null) {
            for (Label item : matchLabels) {
                this.addToMatchLabels(item);
            }
        }
        return (A)((Object)this);
    }

    public Label[] buildMatchLabels() {
        int size = this.matchLabels != null ? this.matchLabels.size() : 0;
        Label[] result = new Label[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.matchLabels) {
            result[index++] = (Label)visitableBuilder.build();
        }
        return result;
    }

    public Label buildMatchLabel(int index) {
        return this.matchLabels.get(index).build();
    }

    public Label buildFirstMatchLabel() {
        return this.matchLabels.get(0).build();
    }

    public Label buildLastMatchLabel() {
        return this.matchLabels.get(this.matchLabels.size() - 1).build();
    }

    public Label buildMatchingMatchLabel(Predicate<LabelBuilder> predicate) {
        for (LabelBuilder item : this.matchLabels) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMatchLabel(Predicate<LabelBuilder> predicate) {
        for (LabelBuilder item : this.matchLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToMatchLabels(int index, Label item) {
        if (this.matchLabels == null) {
            this.matchLabels = new ArrayList();
        }
        LabelBuilder builder = new LabelBuilder(item);
        if (index < 0 || index >= this.matchLabels.size()) {
            this._visitables.get((Object)"matchLabels").add(builder);
            this.matchLabels.add(builder);
        } else {
            this._visitables.get((Object)"matchLabels").add(index, builder);
            this.matchLabels.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToMatchLabels(int index, Label item) {
        if (this.matchLabels == null) {
            this.matchLabels = new ArrayList();
        }
        LabelBuilder builder = new LabelBuilder(item);
        if (index < 0 || index >= this.matchLabels.size()) {
            this._visitables.get((Object)"matchLabels").add(builder);
            this.matchLabels.add(builder);
        } else {
            this._visitables.get((Object)"matchLabels").set(index, builder);
            this.matchLabels.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToMatchLabels(Label ... items) {
        if (this.matchLabels == null) {
            this.matchLabels = new ArrayList();
        }
        for (Label item : items) {
            LabelBuilder builder = new LabelBuilder(item);
            this._visitables.get((Object)"matchLabels").add(builder);
            this.matchLabels.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToMatchLabels(Collection<Label> items) {
        if (this.matchLabels == null) {
            this.matchLabels = new ArrayList();
        }
        for (Label item : items) {
            LabelBuilder builder = new LabelBuilder(item);
            this._visitables.get((Object)"matchLabels").add(builder);
            this.matchLabels.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromMatchLabels(Label ... items) {
        if (this.matchLabels == null) {
            return (A)((Object)this);
        }
        for (Label item : items) {
            LabelBuilder builder = new LabelBuilder(item);
            this._visitables.get((Object)"matchLabels").remove((Object)builder);
            this.matchLabels.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMatchLabels(Collection<Label> items) {
        if (this.matchLabels == null) {
            return (A)((Object)this);
        }
        for (Label item : items) {
            LabelBuilder builder = new LabelBuilder(item);
            this._visitables.get((Object)"matchLabels").remove((Object)builder);
            this.matchLabels.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMatchLabels(Predicate<LabelBuilder> predicate) {
        if (this.matchLabels == null) {
            return (A)((Object)this);
        }
        Iterator<LabelBuilder> each = this.matchLabels.iterator();
        List visitables = this._visitables.get((Object)"matchLabels");
        while (each.hasNext()) {
            LabelBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasMatchLabels() {
        return this.matchLabels != null && !this.matchLabels.isEmpty();
    }

    public A addNewMatchLabel(String key, String value, String[] kinds) {
        return this.addToMatchLabels(new Label(key, value, kinds));
    }

    public MatchLabelsNested<A> addNewMatchLabel() {
        return new MatchLabelsNested(-1, null);
    }

    public MatchLabelsNested<A> addNewMatchLabelLike(Label item) {
        return new MatchLabelsNested(-1, item);
    }

    public MatchLabelsNested<A> setNewMatchLabelLike(int index, Label item) {
        return new MatchLabelsNested(index, item);
    }

    public MatchLabelsNested<A> editMatchLabel(int index) {
        if (this.matchLabels.size() <= index) {
            throw new RuntimeException("Can't edit matchLabels. Index exceeds size.");
        }
        return this.setNewMatchLabelLike(index, this.buildMatchLabel(index));
    }

    public MatchLabelsNested<A> editFirstMatchLabel() {
        if (this.matchLabels.size() == 0) {
            throw new RuntimeException("Can't edit first matchLabels. The list is empty.");
        }
        return this.setNewMatchLabelLike(0, this.buildMatchLabel(0));
    }

    public MatchLabelsNested<A> editLastMatchLabel() {
        int index = this.matchLabels.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last matchLabels. The list is empty.");
        }
        return this.setNewMatchLabelLike(index, this.buildMatchLabel(index));
    }

    public MatchLabelsNested<A> editMatchingMatchLabel(Predicate<LabelBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matchLabels.size(); ++i) {
            if (!predicate.test(this.matchLabels.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching matchLabels. No match found.");
        }
        return this.setNewMatchLabelLike(index, this.buildMatchLabel(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PersistentVolumeClaimConfigFluent that = (PersistentVolumeClaimConfigFluent)((Object)o);
        if (this.size != that.size) {
            return false;
        }
        if (!Objects.equals(this.unit, that.unit)) {
            return false;
        }
        if (!Objects.equals(this.storageClass, that.storageClass)) {
            return false;
        }
        if (!Objects.equals((Object)this.accessMode, (Object)that.accessMode)) {
            return false;
        }
        return Objects.equals(this.matchLabels, that.matchLabels);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.size, this.unit, this.storageClass, this.accessMode, this.matchLabels, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("size:");
        sb.append(this.size + ",");
        if (this.unit != null) {
            sb.append("unit:");
            sb.append(this.unit + ",");
        }
        if (this.storageClass != null) {
            sb.append("storageClass:");
            sb.append(this.storageClass + ",");
        }
        if (this.accessMode != null) {
            sb.append("accessMode:");
            sb.append((Object)((Object)this.accessMode) + ",");
        }
        if (this.matchLabels != null && !this.matchLabels.isEmpty()) {
            sb.append("matchLabels:");
            sb.append(this.matchLabels);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MatchLabelsNested<N>
    extends LabelFluent<MatchLabelsNested<N>>
    implements Nested<N> {
        LabelBuilder builder;
        int index;

        MatchLabelsNested(int index, Label item) {
            this.index = index;
            this.builder = new LabelBuilder(this, item);
        }

        public N and() {
            return (N)PersistentVolumeClaimConfigFluent.this.setToMatchLabels(this.index, this.builder.build());
        }

        public N endMatchLabel() {
            return this.and();
        }
    }
}

