/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.configurator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.BaseConfigFluent;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.Port;
import java.util.Objects;

@Description(value="adds a port to all containers.")
public class AddPort
extends Configurator<BaseConfigFluent> {
    private final Port port;

    public AddPort(Port port) {
        this.port = port;
    }

    public void visit(BaseConfigFluent config) {
        if (!this.hasPort(config)) {
            config.addToPorts(this.port);
        }
    }

    private boolean hasPort(BaseConfigFluent config) {
        for (Port p : config.buildPorts()) {
            if (p.getContainerPort() != this.port.getContainerPort()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AddPort addPort = (AddPort)((Object)o);
        return Objects.equals(this.port, addPort.port);
    }

    public int hashCode() {
        return Objects.hash(this.port);
    }
}

