/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.WithProject;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.kubernetes.decorator.RemoveAnnotationDecorator;
import io.dekorate.project.Project;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

@Description(value="Add a vcs uri label to the all metadata.")
public class AddCommitIdAnnotationDecorator
extends NamedResourceDecorator<ObjectMetaBuilder>
implements WithProject {
    private final String annotationKey;

    public AddCommitIdAnnotationDecorator() {
        this(ANY);
    }

    public AddCommitIdAnnotationDecorator(String name) {
        this(name, "app.dekorate.io/commit-id");
    }

    public AddCommitIdAnnotationDecorator(String name, String annotationKey) {
        super(name);
        this.annotationKey = annotationKey;
    }

    @Override
    public void andThenVisit(ObjectMetaBuilder builder, ObjectMeta resourceMeta) {
        boolean hasCommit;
        Project p = this.getProject();
        boolean bl = hasCommit = p.getScmInfo() != null && p.getScmInfo().getCommit() != null;
        if (hasCommit) {
            builder.addToAnnotations(this.annotationKey, this.getProject().getScmInfo().getCommit());
        }
    }

    public String getAnnotationKey() {
        return this.annotationKey;
    }

    @Override
    public Class<? extends Decorator>[] before() {
        return new Class[]{RemoveAnnotationDecorator.class};
    }

    public int hashCode() {
        int prime = 31;
        int result = 1 + this.getClass().hashCode();
        result = 31 * result + (this.annotationKey == null ? 0 : this.annotationKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddCommitIdAnnotationDecorator other = (AddCommitIdAnnotationDecorator)obj;
        return !(this.annotationKey == null ? other.annotationKey != null : !this.annotationKey.equals(other.annotationKey));
    }
}

