/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.Item;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.fabric8.kubernetes.api.model.KeyToPath;
import io.fabric8.kubernetes.api.model.KeyToPathBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Description(value="Add a configmap volume to the pod spec.")
public class AddConfigMapVolumeDecorator
extends NamedResourceDecorator<PodSpecFluent<?>> {
    private final ConfigMapVolume volume;

    public AddConfigMapVolumeDecorator(ConfigMapVolume volume) {
        this(ANY, volume);
    }

    public AddConfigMapVolumeDecorator(String name, ConfigMapVolume volume) {
        super(name);
        this.volume = volume;
    }

    @Override
    public void andThenVisit(PodSpecFluent<?> podSpec, ObjectMeta resourceMeta) {
        ((PodSpecFluent.VolumesNested)((VolumeFluent.ConfigMapNested)((VolumeFluent.ConfigMapNested)((VolumeFluent.ConfigMapNested)((VolumeFluent.ConfigMapNested)((PodSpecFluent.VolumesNested)podSpec.addNewVolume().withName(this.volume.getVolumeName())).withNewConfigMap().withName(this.volume.getConfigMapName())).withDefaultMode(this.volume.getDefaultMode())).withOptional(Boolean.valueOf(this.volume.isOptional()))).withItems(this.mapKeyToPathList(this.volume.getItems()))).endConfigMap()).endVolume();
    }

    private List<KeyToPath> mapKeyToPathList(Item[] items) {
        if (items == null || items.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<KeyToPath> keyToPathList = new ArrayList<KeyToPath>(items.length);
        for (Item item : items) {
            KeyToPathBuilder builder = (KeyToPathBuilder)((KeyToPathBuilder)new KeyToPathBuilder().withKey(item.getKey())).withPath(item.getPath());
            if (item.getMode() > 0) {
                builder.withMode(item.getMode());
            }
            keyToPathList.add(builder.build());
        }
        return keyToPathList;
    }
}

