/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.ConfigReference;
import io.dekorate.WithConfigReferences;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressSpecFluent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Description(value="Add an ingress to the list.")
public class AddIngressDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder>
implements WithConfigReferences {
    private final KubernetesConfig config;
    private final Map<String, String> allLabels;

    public AddIngressDecorator(KubernetesConfig config, Map<String, String> allLabels) {
        this.config = config;
        this.allLabels = allLabels;
    }

    public void visit(KubernetesListBuilder list) {
        if (!this.config.getIngress().isExpose()) {
            return;
        }
        if (this.contains(list, ANY, "Ingress", this.config.getName())) {
            return;
        }
        list.addToItems(new HasMetadata[]{((IngressBuilder)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)((IngressFluent.SpecNested)((IngressBuilder)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)new IngressBuilder().withNewMetadata().withName(this.config.getName())).withLabels(this.allLabels)).endMetadata()).withNewSpec().withIngressClassName(Strings.defaultIfEmpty((String)this.config.getIngress().getIngressClassName(), null))).addNewRule().withHost(this.config.getIngress().getHost())).endRule()).endSpec()).build()});
    }

    public List<ConfigReference> getConfigReferences() {
        if (!this.config.getIngress().isExpose()) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.buildConfigReferenceHost());
    }

    private ConfigReference buildConfigReferenceHost() {
        String property = "host";
        String path = "(kind == Ingress && metadata.name == " + this.config.getName() + ").spec.rules.host";
        return new ConfigReference.Builder(property, path).withDescription("The host under which the application is going to be exposed.").withValue((Object)this.config.getIngress().getHost()).build();
    }
}

