/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.adapter.ContainerAdapter;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.Job;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Images;
import io.dekorate.utils.Labels;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.batch.v1.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.JobFluent;
import io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Description(value="Add a job to the list.")
public class AddJobDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private static final String API_VERSION = "batch/v1";
    private static final String KIND = "Job";
    private final BaseConfig config;
    private final Job job;

    public AddJobDecorator(BaseConfig config, Job job) {
        this.config = config;
        this.job = job;
        if (job.getContainers() == null || job.getContainers().length == 0) {
            throw new RuntimeException("No containers set in the Job definition.");
        }
    }

    public void visit(KubernetesListBuilder list) {
        String name = Strings.defaultIfEmpty((String)this.job.getName(), (String)this.config.getName());
        if (this.contains(list, API_VERSION, KIND, name)) {
            return;
        }
        JobFluent.SpecNested jobBuilder = (JobFluent.SpecNested)((JobFluent.SpecNested)((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((JobBuilder)new JobBuilder().withApiVersion(API_VERSION)).withNewMetadata().withName(name)).withLabels(Labels.createLabelsAsMap((BaseConfig)this.config, (String)KIND))).endMetadata()).withNewSpec().withCompletionMode(this.job.getCompletionMode().name())).withSuspend(this.job.getSuspend());
        if (this.job.getParallelism() >= 0) {
            jobBuilder = (JobFluent.SpecNested)jobBuilder.withParallelism(this.job.getParallelism());
        }
        if (this.job.getCompletions() >= 0) {
            jobBuilder = (JobFluent.SpecNested)jobBuilder.withCompletions(this.job.getCompletions());
        }
        if (this.job.getBackoffLimit() >= 0) {
            jobBuilder = (JobFluent.SpecNested)jobBuilder.withBackoffLimit(this.job.getBackoffLimit());
        }
        if (this.job.getActiveDeadlineSeconds() >= 0L) {
            jobBuilder = (JobFluent.SpecNested)jobBuilder.withActiveDeadlineSeconds(this.job.getActiveDeadlineSeconds());
        }
        if (this.job.getTtlSecondsAfterFinished() >= 0) {
            jobBuilder = (JobFluent.SpecNested)jobBuilder.withTtlSecondsAfterFinished(this.job.getTtlSecondsAfterFinished());
        }
        list.addToItems(new HasMetadata[]{((JobBuilder)((JobFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)jobBuilder.withNewTemplate().withNewSpec().addAllToContainers((Collection)Stream.of(this.job.getContainers()).map(this::toKubernetesContainer).collect(Collectors.toSet()))).withRestartPolicy(this.job.getRestartPolicy().name())).endSpec()).endTemplate()).endSpec()).build()});
    }

    private io.fabric8.kubernetes.api.model.Container toKubernetesContainer(Container container) {
        ContainerBuilder builder = new ContainerBuilder();
        ContainerAdapter.applyContainerToBuilder(builder, container);
        if (Strings.isNullOrEmpty((String)builder.getName())) {
            builder = (ContainerBuilder)builder.withName(Images.getName((String)container.getImage()));
        }
        return builder.build();
    }
}

