/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.kubernetes.decorator.RemoveLabelDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

@Description(value="Add a vcs url label to the all metadata.")
public class AddVcsUrlAnnotationDecorator
extends NamedResourceDecorator<ObjectMetaBuilder> {
    private final String annotationKey;
    private final String url;

    public AddVcsUrlAnnotationDecorator(String name, String annotationKey, String url) {
        super(name);
        this.url = url;
        this.annotationKey = annotationKey;
    }

    @Override
    public void andThenVisit(ObjectMetaBuilder builder, ObjectMeta resourceMeta) {
        if (Strings.isNotNullOrEmpty((String)this.url)) {
            builder.addToAnnotations(this.annotationKey, this.url);
        }
    }

    public String getAnnotationKey() {
        return this.annotationKey;
    }

    @Override
    public Class<? extends Decorator>[] before() {
        return new Class[]{RemoveLabelDecorator.class};
    }

    public int hashCode() {
        int prime = 31;
        int result = 1 + this.getClass().hashCode();
        result = 31 * result + (this.annotationKey == null ? 0 : this.annotationKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddVcsUrlAnnotationDecorator other = (AddVcsUrlAnnotationDecorator)obj;
        return !(this.annotationKey == null ? other.annotationKey != null : !this.annotationKey.equals(other.annotationKey));
    }
}

