package io.dekorate.s2i.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.ImageConfiguration;
import java.lang.Object;
import java.lang.String;
import io.dekorate.kubernetes.config.Env;
import java.lang.Boolean;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

 /**
  * Generated
  */
  @Buildable(builderPackage = "io.fabric8.kubernetes.api.builder")
  public class S2iBuildConfig extends ImageConfiguration{
  public S2iBuildConfig() {
  }
  public S2iBuildConfig(Project project,Map<ConfigKey,Object> attributes,Boolean enabled,String registry,String group,String name,String version,String image,String dockerFile,Boolean autoBuildEnabled,Boolean autoPushEnabled,Boolean autoLoadEnabled,String builderImage,Env[] buildEnvVars,Boolean autoDeployEnabled) {
    super(project, attributes, enabled, registry, group, name, version, image, dockerFile, autoBuildEnabled, autoPushEnabled, autoLoadEnabled);
    this.builderImage = builderImage;
    this.buildEnvVars = buildEnvVars != null ? buildEnvVars : new Env[0];
    this.autoDeployEnabled = autoDeployEnabled;
  }
  private String builderImage;
  private Env[] buildEnvVars = new Env[0];
  private Boolean autoDeployEnabled;
  
  /**
   * The S2i builder image to use.
   * @return The builder image.
   */
public String getBuilderImage() {
    return this.builderImage;
  }
  
  /**
   * Environment variables to use for the s2i build.
   * @return The environment variables.
   */
public Env[] getBuildEnvVars() {
    return this.buildEnvVars;
  }
  
  /**
   * Flag to trigger the registration of the deploy hook. It's generally
   * preferable to use `-Ddekorate.deploy=true` instead of hardcoding this here.
   * @return True for automatic registration of the build hook.
   */
public Boolean getAutoDeployEnabled() {
    return this.autoDeployEnabled;
  }
  
  /**
   * Flag to trigger the registration of the deploy hook. It's generally
   * preferable to use `-Ddekorate.deploy=true` instead of hardcoding this here.
   * @return True for automatic registration of the build hook.
   */
public boolean isAutoDeployEnabled() {
    return this.autoDeployEnabled != null &&  this.autoDeployEnabled;
  }
  public static S2iBuildConfigBuilder newS2iBuildConfigBuilder() {
    return new S2iBuildConfigBuilder();
  }
  public static S2iBuildConfigBuilder newS2iBuildConfigBuilderFromDefaults() {
    return new S2iBuildConfigBuilder().withEnabled(true).withDockerFile("Dockerfile").withBuilderImage("fabric8/s2i-java:2.3").withAutoPushEnabled(false).withAutoBuildEnabled(false).withAutoDeployEnabled(false);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    S2iBuildConfig that = (S2iBuildConfig) o;
    if (builderImage != null ? !builderImage.equals(that.builderImage) :that.builderImage != null) return false;
    if (buildEnvVars != null ? !buildEnvVars.equals(that.buildEnvVars) :that.buildEnvVars != null) return false;
    if (autoDeployEnabled != null ? !autoDeployEnabled.equals(that.autoDeployEnabled) :that.autoDeployEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(builderImage,  buildEnvVars,  autoDeployEnabled,  super.hashCode());
  }
  
}