/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.servicebinding.config;

import io.dekorate.kubernetes.config.ApplicationConfiguration;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.project.Project;
import io.dekorate.servicebinding.config.ApplicationConfig;
import io.dekorate.servicebinding.config.BindingPathConfig;
import io.dekorate.servicebinding.config.ServiceBindingConfigBuilder;
import io.dekorate.servicebinding.config.ServiceConfig;
import java.util.Map;
import java.util.Objects;

public class ServiceBindingConfig
extends ApplicationConfiguration {
    private ApplicationConfig application;
    private ServiceConfig[] services = new ServiceConfig[0];
    private String envVarPrefix;
    private Boolean detectBindingResources;
    private Boolean bindAsFiles;
    private String mountPath;
    private Env[] customEnvVar = new Env[0];
    private BindingPathConfig bindingPath;

    public ServiceBindingConfig() {
    }

    public ServiceBindingConfig(Project project, Map<ConfigKey, Object> attributes, String partOf, String name, String version, ApplicationConfig application, ServiceConfig[] services, String envVarPrefix, Boolean detectBindingResources, Boolean bindAsFiles, String mountPath, Env[] customEnvVar, BindingPathConfig bindingPath) {
        super(project, attributes, partOf, name, version);
        this.application = application;
        this.services = services != null ? services : new ServiceConfig[]{};
        this.envVarPrefix = envVarPrefix;
        this.detectBindingResources = detectBindingResources;
        this.bindAsFiles = bindAsFiles;
        this.mountPath = mountPath;
        this.customEnvVar = customEnvVar != null ? customEnvVar : new Env[]{};
        this.bindingPath = bindingPath;
    }

    public ApplicationConfig getApplication() {
        return this.application;
    }

    public ServiceConfig[] getServices() {
        return this.services;
    }

    public String getEnvVarPrefix() {
        return this.envVarPrefix;
    }

    public Boolean getDetectBindingResources() {
        return this.detectBindingResources;
    }

    public boolean isDetectBindingResources() {
        return this.detectBindingResources != null && this.detectBindingResources != false;
    }

    public Boolean getBindAsFiles() {
        return this.bindAsFiles;
    }

    public boolean isBindAsFiles() {
        return this.bindAsFiles != null && this.bindAsFiles != false;
    }

    public String getMountPath() {
        return this.mountPath;
    }

    public Env[] getCustomEnvVar() {
        return this.customEnvVar;
    }

    public BindingPathConfig getBindingPath() {
        return this.bindingPath;
    }

    public static ServiceBindingConfigBuilder newServiceBindingConfigBuilder() {
        return new ServiceBindingConfigBuilder();
    }

    public static ServiceBindingConfigBuilder newServiceBindingConfigBuilderFromDefaults() {
        return (ServiceBindingConfigBuilder)((ServiceBindingConfigBuilder)((ServiceBindingConfigBuilder)((ServiceBindingConfigBuilder)new ServiceBindingConfigBuilder().withApplication(new ApplicationConfig())).withDetectBindingResources(false)).withBindAsFiles(false)).withBindingPath(new BindingPathConfig());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceBindingConfig that = (ServiceBindingConfig)((Object)o);
        if (this.application != null ? !this.application.equals((Object)that.application) : that.application != null) {
            return false;
        }
        if (this.services != null ? !this.services.equals(that.services) : that.services != null) {
            return false;
        }
        if (this.envVarPrefix != null ? !this.envVarPrefix.equals(that.envVarPrefix) : that.envVarPrefix != null) {
            return false;
        }
        if (this.detectBindingResources != null ? !this.detectBindingResources.equals(that.detectBindingResources) : that.detectBindingResources != null) {
            return false;
        }
        if (this.bindAsFiles != null ? !this.bindAsFiles.equals(that.bindAsFiles) : that.bindAsFiles != null) {
            return false;
        }
        if (this.mountPath != null ? !this.mountPath.equals(that.mountPath) : that.mountPath != null) {
            return false;
        }
        if (this.customEnvVar != null ? !this.customEnvVar.equals(that.customEnvVar) : that.customEnvVar != null) {
            return false;
        }
        return !(this.bindingPath != null ? !this.bindingPath.equals((Object)that.bindingPath) : that.bindingPath != null);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.application, this.services, this.envVarPrefix, this.detectBindingResources, this.bindAsFiles, this.mountPath, this.customEnvVar, this.bindingPath, super.hashCode()});
    }
}

