/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.servicebinding.model;

import io.dekorate.servicebinding.model.Application;
import io.dekorate.servicebinding.model.ApplicationFluent;
import io.dekorate.servicebinding.model.BindingPath;
import io.dekorate.servicebinding.model.BindingPathBuilder;
import io.dekorate.servicebinding.model.BindingPathFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;

public class ApplicationFluentImpl<A extends ApplicationFluent<A>>
extends BaseFluent<A>
implements ApplicationFluent<A> {
    private String resource;
    private String kind;
    private String group;
    private String version;
    private String name;
    private BindingPathBuilder bindingPath;

    public ApplicationFluentImpl() {
    }

    public ApplicationFluentImpl(Application instance) {
        this.withResource(instance.getResource());
        this.withKind(instance.getKind());
        this.withGroup(instance.getGroup());
        this.withVersion(instance.getVersion());
        this.withName(instance.getName());
        this.withBindingPath(instance.getBindingPath());
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public A withResource(String resource) {
        this.resource = resource;
        return (A)this;
    }

    @Override
    public Boolean hasResource() {
        return this.resource != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    @Override
    public Boolean hasGroup() {
        return this.group != null;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public BindingPath getBindingPath() {
        return this.bindingPath != null ? this.bindingPath.build() : null;
    }

    @Override
    public BindingPath buildBindingPath() {
        return this.bindingPath != null ? this.bindingPath.build() : null;
    }

    @Override
    public A withBindingPath(BindingPath bindingPath) {
        this._visitables.get((Object)"bindingPath").remove(this.bindingPath);
        if (bindingPath != null) {
            this.bindingPath = new BindingPathBuilder(bindingPath);
            this._visitables.get((Object)"bindingPath").add(this.bindingPath);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBindingPath() {
        return this.bindingPath != null;
    }

    @Override
    public A withNewBindingPath(String containerPath, String secretPath) {
        return this.withBindingPath(new BindingPath(containerPath, secretPath));
    }

    @Override
    public ApplicationFluent.BindingPathNested<A> withNewBindingPath() {
        return new BindingPathNestedImpl();
    }

    @Override
    public ApplicationFluent.BindingPathNested<A> withNewBindingPathLike(BindingPath item) {
        return new BindingPathNestedImpl(item);
    }

    @Override
    public ApplicationFluent.BindingPathNested<A> editBindingPath() {
        return this.withNewBindingPathLike(this.getBindingPath());
    }

    @Override
    public ApplicationFluent.BindingPathNested<A> editOrNewBindingPath() {
        return this.withNewBindingPathLike(this.getBindingPath() != null ? this.getBindingPath() : new BindingPathBuilder().build());
    }

    @Override
    public ApplicationFluent.BindingPathNested<A> editOrNewBindingPathLike(BindingPath item) {
        return this.withNewBindingPathLike(this.getBindingPath() != null ? this.getBindingPath() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationFluentImpl that = (ApplicationFluentImpl)o;
        if (this.resource != null ? !this.resource.equals(that.resource) : that.resource != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.bindingPath != null ? !this.bindingPath.equals(that.bindingPath) : that.bindingPath != null);
    }

    public int hashCode() {
        return Objects.hash(this.resource, this.kind, this.group, this.version, this.name, this.bindingPath, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resource != null) {
            sb.append("resource:");
            sb.append(this.resource + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.group != null) {
            sb.append("group:");
            sb.append(this.group + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.bindingPath != null) {
            sb.append("bindingPath:");
            sb.append(this.bindingPath);
        }
        sb.append("}");
        return sb.toString();
    }

    class BindingPathNestedImpl<N>
    extends BindingPathFluentImpl<ApplicationFluent.BindingPathNested<N>>
    implements ApplicationFluent.BindingPathNested<N>,
    Nested<N> {
        BindingPathBuilder builder;

        BindingPathNestedImpl(BindingPath item) {
            this.builder = new BindingPathBuilder(this, item);
        }

        BindingPathNestedImpl() {
            this.builder = new BindingPathBuilder(this);
        }

        @Override
        public N and() {
            return (N)ApplicationFluentImpl.this.withBindingPath(this.builder.build());
        }

        @Override
        public N endBindingPath() {
            return this.and();
        }
    }
}

