/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.annotation.AccessMode;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.PersistentVolumeClaimBuilder;
import java.util.Objects;

public class PersistentVolumeClaim {
    private String name;
    private Integer size;
    private String unit;
    private String storageClass;
    private AccessMode accessMode;
    private Label[] matchLabels = new Label[0];

    public PersistentVolumeClaim() {
    }

    public PersistentVolumeClaim(String name, Integer size, String unit, String storageClass, AccessMode accessMode, Label[] matchLabels) {
        this.name = name;
        this.size = size;
        this.unit = unit;
        this.storageClass = storageClass;
        this.accessMode = accessMode;
        this.matchLabels = matchLabels != null ? matchLabels : new Label[]{};
    }

    public String getName() {
        return this.name;
    }

    public Integer getSize() {
        return this.size;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public Label[] getMatchLabels() {
        return this.matchLabels;
    }

    public static PersistentVolumeClaimBuilder newBuilder() {
        return new PersistentVolumeClaimBuilder();
    }

    public static PersistentVolumeClaimBuilder newBuilderFromDefaults() {
        return (PersistentVolumeClaimBuilder)((PersistentVolumeClaimBuilder)((PersistentVolumeClaimBuilder)((PersistentVolumeClaimBuilder)new PersistentVolumeClaimBuilder().withSize(1)).withUnit("Gi")).withStorageClass("standard")).withAccessMode(AccessMode.ReadWriteOnce);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentVolumeClaim that = (PersistentVolumeClaim)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.size != null ? !this.size.equals(that.size) : that.size != null) {
            return false;
        }
        if (this.unit != null ? !this.unit.equals(that.unit) : that.unit != null) {
            return false;
        }
        if (this.storageClass != null ? !this.storageClass.equals(that.storageClass) : that.storageClass != null) {
            return false;
        }
        if (this.accessMode != null ? !this.accessMode.equals((Object)that.accessMode) : that.accessMode != null) {
            return false;
        }
        return !(this.matchLabels != null ? !this.matchLabels.equals(that.matchLabels) : that.matchLabels != null);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.size, this.unit, this.storageClass, this.accessMode, this.matchLabels, super.hashCode());
    }
}

