/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.tekton.config;

import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.AnnotationBuilder;
import io.dekorate.kubernetes.config.AnnotationFluent;
import io.dekorate.kubernetes.config.AnnotationFluentImpl;
import io.dekorate.kubernetes.config.ApplicationConfigurationFluentImpl;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.LabelBuilder;
import io.dekorate.kubernetes.config.LabelFluent;
import io.dekorate.kubernetes.config.LabelFluentImpl;
import io.dekorate.kubernetes.config.PersistentVolumeClaim;
import io.dekorate.kubernetes.config.PersistentVolumeClaimBuilder;
import io.dekorate.kubernetes.config.PersistentVolumeClaimFluentImpl;
import io.dekorate.tekton.annotation.TektonImageBuildStrategy;
import io.dekorate.tekton.config.TektonConfig;
import io.dekorate.tekton.config.TektonConfigFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class TektonConfigFluentImpl<A extends TektonConfigFluent<A>>
extends ApplicationConfigurationFluentImpl<A>
implements TektonConfigFluent<A> {
    private ArrayList<LabelBuilder> labels = new ArrayList();
    private ArrayList<AnnotationBuilder> annotations = new ArrayList();
    private String externalGitPipelineResource;
    private String sourceWorkspace;
    private String externalSourceWorkspaceClaim;
    private PersistentVolumeClaimBuilder sourceWorkspaceClaim;
    private String m2Workspace;
    private String externalM2WorkspaceClaim;
    private PersistentVolumeClaimBuilder m2WorkspaceClaim;
    private String projectBuilderImage;
    private String projectBuilderCommand;
    private List<String> projectBuilderArguments = new ArrayList<String>();
    private TektonImageBuildStrategy imageBuildStrategy;
    private String imageBuildImage;
    private String imageBuildCommand;
    private List<String> imageBuildArguments = new ArrayList<String>();
    private String imagePushImage;
    private String imagePushCommand;
    private List<String> imagePushArguments = new ArrayList<String>();
    private String dockerfile;
    private String deployerImage;
    private String imagePushServiceAccount;
    private String imagePushSecret;
    private Boolean useLocalDockerConfigJson;
    private String registry;
    private String registryUsername;
    private String registryPassword;

    public TektonConfigFluentImpl() {
    }

    public TektonConfigFluentImpl(TektonConfig instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withPartOf(instance.getPartOf());
        this.withName(instance.getName());
        this.withVersion(instance.getVersion());
        this.withLabels(instance.getLabels());
        this.withAnnotations(instance.getAnnotations());
        this.withExternalGitPipelineResource(instance.getExternalGitPipelineResource());
        this.withSourceWorkspace(instance.getSourceWorkspace());
        this.withExternalSourceWorkspaceClaim(instance.getExternalSourceWorkspaceClaim());
        this.withSourceWorkspaceClaim(instance.getSourceWorkspaceClaim());
        this.withM2Workspace(instance.getM2Workspace());
        this.withExternalM2WorkspaceClaim(instance.getExternalM2WorkspaceClaim());
        this.withM2WorkspaceClaim(instance.getM2WorkspaceClaim());
        this.withProjectBuilderImage(instance.getProjectBuilderImage());
        this.withProjectBuilderCommand(instance.getProjectBuilderCommand());
        this.withProjectBuilderArguments(instance.getProjectBuilderArguments());
        this.withImageBuildStrategy(instance.getImageBuildStrategy());
        this.withImageBuildImage(instance.getImageBuildImage());
        this.withImageBuildCommand(instance.getImageBuildCommand());
        this.withImageBuildArguments(instance.getImageBuildArguments());
        this.withImagePushImage(instance.getImagePushImage());
        this.withImagePushCommand(instance.getImagePushCommand());
        this.withImagePushArguments(instance.getImagePushArguments());
        this.withDockerfile(instance.getDockerfile());
        this.withDeployerImage(instance.getDeployerImage());
        this.withImagePushServiceAccount(instance.getImagePushServiceAccount());
        this.withImagePushSecret(instance.getImagePushSecret());
        this.withUseLocalDockerConfigJson(instance.getUseLocalDockerConfigJson());
        this.withRegistry(instance.getRegistry());
        this.withRegistryUsername(instance.getRegistryUsername());
        this.withRegistryPassword(instance.getRegistryPassword());
    }

    @Override
    public A withLabels(Label ... labels) {
        if (this.labels != null) {
            this.labels.clear();
        }
        if (labels != null) {
            for (Label item : labels) {
                this.addToLabels(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Label[] getLabels() {
        int size = this.labels != null ? this.labels.size() : 0;
        Label[] result = new Label[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.labels) {
            result[index++] = (Label)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Label[] buildLabels() {
        int size = this.labels != null ? this.labels.size() : 0;
        Label[] result = new Label[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.labels) {
            result[index++] = (Label)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Label buildLabel(Integer index) {
        return this.labels.get(index).build();
    }

    @Override
    public Label buildFirstLabel() {
        return this.labels.get(0).build();
    }

    @Override
    public Label buildLastLabel() {
        return this.labels.get(this.labels.size() - 1).build();
    }

    @Override
    public Label buildMatchingLabel(Predicate<LabelBuilder> predicate) {
        for (LabelBuilder item : this.labels) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingLabel(Predicate<LabelBuilder> predicate) {
        for (LabelBuilder item : this.labels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToLabels(Integer index, Label item) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        LabelBuilder builder = new LabelBuilder(item);
        this._visitables.get((Object)"labels").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"labels").size(), builder);
        this.labels.add(index >= 0 ? index.intValue() : this.labels.size(), builder);
        return (A)this;
    }

    @Override
    public A setToLabels(Integer index, Label item) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        LabelBuilder builder = new LabelBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"labels").size()) {
            this._visitables.get((Object)"labels").add(builder);
        } else {
            this._visitables.get((Object)"labels").set(index, builder);
        }
        if (index < 0 || index >= this.labels.size()) {
            this.labels.add(builder);
        } else {
            this.labels.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(Label ... items) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        for (Label item : items) {
            LabelBuilder builder = new LabelBuilder(item);
            this._visitables.get((Object)"labels").add(builder);
            this.labels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToLabels(Collection<Label> items) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        for (Label item : items) {
            LabelBuilder builder = new LabelBuilder(item);
            this._visitables.get((Object)"labels").add(builder);
            this.labels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(Label ... items) {
        for (Label item : items) {
            LabelBuilder builder = new LabelBuilder(item);
            this._visitables.get((Object)"labels").remove(builder);
            if (this.labels == null) continue;
            this.labels.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLabels(Collection<Label> items) {
        for (Label item : items) {
            LabelBuilder builder = new LabelBuilder(item);
            this._visitables.get((Object)"labels").remove(builder);
            if (this.labels == null) continue;
            this.labels.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromLabels(Predicate<LabelBuilder> predicate) {
        if (this.labels == null) {
            return (A)this;
        }
        Iterator<LabelBuilder> each = this.labels.iterator();
        List visitables = this._visitables.get((Object)"labels");
        while (each.hasNext()) {
            LabelBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.labels != null && !this.labels.isEmpty();
    }

    @Override
    public A addNewLabel(String key, String value, String[] kinds) {
        return this.addToLabels(new Label(key, value, kinds));
    }

    @Override
    public TektonConfigFluent.LabelsNested<A> addNewLabel() {
        return new LabelsNestedImpl();
    }

    @Override
    public TektonConfigFluent.LabelsNested<A> addNewLabelLike(Label item) {
        return new LabelsNestedImpl(-1, item);
    }

    @Override
    public TektonConfigFluent.LabelsNested<A> setNewLabelLike(Integer index, Label item) {
        return new LabelsNestedImpl(index, item);
    }

    @Override
    public TektonConfigFluent.LabelsNested<A> editLabel(Integer index) {
        if (this.labels.size() <= index) {
            throw new RuntimeException("Can't edit labels. Index exceeds size.");
        }
        return this.setNewLabelLike(index, this.buildLabel(index));
    }

    @Override
    public TektonConfigFluent.LabelsNested<A> editFirstLabel() {
        if (this.labels.size() == 0) {
            throw new RuntimeException("Can't edit first labels. The list is empty.");
        }
        return this.setNewLabelLike(0, this.buildLabel(0));
    }

    @Override
    public TektonConfigFluent.LabelsNested<A> editLastLabel() {
        int index = this.labels.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last labels. The list is empty.");
        }
        return this.setNewLabelLike(index, this.buildLabel(index));
    }

    @Override
    public TektonConfigFluent.LabelsNested<A> editMatchingLabel(Predicate<LabelBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.labels.size(); ++i) {
            if (!predicate.test(this.labels.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching labels. No match found.");
        }
        return this.setNewLabelLike(index, this.buildLabel(index));
    }

    @Override
    public A withAnnotations(Annotation ... annotations) {
        if (this.annotations != null) {
            this.annotations.clear();
        }
        if (annotations != null) {
            for (Annotation item : annotations) {
                this.addToAnnotations(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Annotation[] getAnnotations() {
        int size = this.annotations != null ? this.annotations.size() : 0;
        Annotation[] result = new Annotation[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.annotations) {
            result[index++] = (Annotation)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Annotation[] buildAnnotations() {
        int size = this.annotations != null ? this.annotations.size() : 0;
        Annotation[] result = new Annotation[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.annotations) {
            result[index++] = (Annotation)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Annotation buildAnnotation(Integer index) {
        return this.annotations.get(index).build();
    }

    @Override
    public Annotation buildFirstAnnotation() {
        return this.annotations.get(0).build();
    }

    @Override
    public Annotation buildLastAnnotation() {
        return this.annotations.get(this.annotations.size() - 1).build();
    }

    @Override
    public Annotation buildMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
        for (AnnotationBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
        for (AnnotationBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToAnnotations(Integer index, Annotation item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationBuilder builder = new AnnotationBuilder(item);
        this._visitables.get((Object)"annotations").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"annotations").size(), builder);
        this.annotations.add(index >= 0 ? index.intValue() : this.annotations.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAnnotations(Integer index, Annotation item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationBuilder builder = new AnnotationBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"annotations").size()) {
            this._visitables.get((Object)"annotations").add(builder);
        } else {
            this._visitables.get((Object)"annotations").set(index, builder);
        }
        if (index < 0 || index >= this.annotations.size()) {
            this.annotations.add(builder);
        } else {
            this.annotations.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Annotation ... items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (Annotation item : items) {
            AnnotationBuilder builder = new AnnotationBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAnnotations(Collection<Annotation> items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (Annotation item : items) {
            AnnotationBuilder builder = new AnnotationBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Annotation ... items) {
        for (Annotation item : items) {
            AnnotationBuilder builder = new AnnotationBuilder(item);
            this._visitables.get((Object)"annotations").remove(builder);
            if (this.annotations == null) continue;
            this.annotations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAnnotations(Collection<Annotation> items) {
        for (Annotation item : items) {
            AnnotationBuilder builder = new AnnotationBuilder(item);
            this._visitables.get((Object)"annotations").remove(builder);
            if (this.annotations == null) continue;
            this.annotations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAnnotations(Predicate<AnnotationBuilder> predicate) {
        if (this.annotations == null) {
            return (A)this;
        }
        Iterator<AnnotationBuilder> each = this.annotations.iterator();
        List visitables = this._visitables.get((Object)"annotations");
        while (each.hasNext()) {
            AnnotationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null && !this.annotations.isEmpty();
    }

    @Override
    public A addNewAnnotation(String key, String value, String[] kinds) {
        return this.addToAnnotations(new Annotation(key, value, kinds));
    }

    @Override
    public TektonConfigFluent.AnnotationsNested<A> addNewAnnotation() {
        return new AnnotationsNestedImpl();
    }

    @Override
    public TektonConfigFluent.AnnotationsNested<A> addNewAnnotationLike(Annotation item) {
        return new AnnotationsNestedImpl(-1, item);
    }

    @Override
    public TektonConfigFluent.AnnotationsNested<A> setNewAnnotationLike(Integer index, Annotation item) {
        return new AnnotationsNestedImpl(index, item);
    }

    @Override
    public TektonConfigFluent.AnnotationsNested<A> editAnnotation(Integer index) {
        if (this.annotations.size() <= index) {
            throw new RuntimeException("Can't edit annotations. Index exceeds size.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    @Override
    public TektonConfigFluent.AnnotationsNested<A> editFirstAnnotation() {
        if (this.annotations.size() == 0) {
            throw new RuntimeException("Can't edit first annotations. The list is empty.");
        }
        return this.setNewAnnotationLike(0, this.buildAnnotation(0));
    }

    @Override
    public TektonConfigFluent.AnnotationsNested<A> editLastAnnotation() {
        int index = this.annotations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last annotations. The list is empty.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    @Override
    public TektonConfigFluent.AnnotationsNested<A> editMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.annotations.size(); ++i) {
            if (!predicate.test(this.annotations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching annotations. No match found.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    @Override
    public String getExternalGitPipelineResource() {
        return this.externalGitPipelineResource;
    }

    @Override
    public A withExternalGitPipelineResource(String externalGitPipelineResource) {
        this.externalGitPipelineResource = externalGitPipelineResource;
        return (A)this;
    }

    @Override
    public Boolean hasExternalGitPipelineResource() {
        return this.externalGitPipelineResource != null;
    }

    @Override
    public String getSourceWorkspace() {
        return this.sourceWorkspace;
    }

    @Override
    public A withSourceWorkspace(String sourceWorkspace) {
        this.sourceWorkspace = sourceWorkspace;
        return (A)this;
    }

    @Override
    public Boolean hasSourceWorkspace() {
        return this.sourceWorkspace != null;
    }

    @Override
    public String getExternalSourceWorkspaceClaim() {
        return this.externalSourceWorkspaceClaim;
    }

    @Override
    public A withExternalSourceWorkspaceClaim(String externalSourceWorkspaceClaim) {
        this.externalSourceWorkspaceClaim = externalSourceWorkspaceClaim;
        return (A)this;
    }

    @Override
    public Boolean hasExternalSourceWorkspaceClaim() {
        return this.externalSourceWorkspaceClaim != null;
    }

    @Override
    @Deprecated
    public PersistentVolumeClaim getSourceWorkspaceClaim() {
        return this.sourceWorkspaceClaim != null ? this.sourceWorkspaceClaim.build() : null;
    }

    @Override
    public PersistentVolumeClaim buildSourceWorkspaceClaim() {
        return this.sourceWorkspaceClaim != null ? this.sourceWorkspaceClaim.build() : null;
    }

    @Override
    public A withSourceWorkspaceClaim(PersistentVolumeClaim sourceWorkspaceClaim) {
        this._visitables.get((Object)"sourceWorkspaceClaim").remove(this.sourceWorkspaceClaim);
        if (sourceWorkspaceClaim != null) {
            this.sourceWorkspaceClaim = new PersistentVolumeClaimBuilder(sourceWorkspaceClaim);
            this._visitables.get((Object)"sourceWorkspaceClaim").add(this.sourceWorkspaceClaim);
        } else {
            this.sourceWorkspaceClaim = null;
            this._visitables.get((Object)"sourceWorkspaceClaim").remove(this.sourceWorkspaceClaim);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSourceWorkspaceClaim() {
        return this.sourceWorkspaceClaim != null;
    }

    @Override
    public TektonConfigFluent.SourceWorkspaceClaimNested<A> withNewSourceWorkspaceClaim() {
        return new SourceWorkspaceClaimNestedImpl();
    }

    @Override
    public TektonConfigFluent.SourceWorkspaceClaimNested<A> withNewSourceWorkspaceClaimLike(PersistentVolumeClaim item) {
        return new SourceWorkspaceClaimNestedImpl(item);
    }

    @Override
    public TektonConfigFluent.SourceWorkspaceClaimNested<A> editSourceWorkspaceClaim() {
        return this.withNewSourceWorkspaceClaimLike(this.getSourceWorkspaceClaim());
    }

    @Override
    public TektonConfigFluent.SourceWorkspaceClaimNested<A> editOrNewSourceWorkspaceClaim() {
        return this.withNewSourceWorkspaceClaimLike(this.getSourceWorkspaceClaim() != null ? this.getSourceWorkspaceClaim() : new PersistentVolumeClaimBuilder().build());
    }

    @Override
    public TektonConfigFluent.SourceWorkspaceClaimNested<A> editOrNewSourceWorkspaceClaimLike(PersistentVolumeClaim item) {
        return this.withNewSourceWorkspaceClaimLike(this.getSourceWorkspaceClaim() != null ? this.getSourceWorkspaceClaim() : item);
    }

    @Override
    public String getM2Workspace() {
        return this.m2Workspace;
    }

    @Override
    public A withM2Workspace(String m2Workspace) {
        this.m2Workspace = m2Workspace;
        return (A)this;
    }

    @Override
    public Boolean hasM2Workspace() {
        return this.m2Workspace != null;
    }

    @Override
    public String getExternalM2WorkspaceClaim() {
        return this.externalM2WorkspaceClaim;
    }

    @Override
    public A withExternalM2WorkspaceClaim(String externalM2WorkspaceClaim) {
        this.externalM2WorkspaceClaim = externalM2WorkspaceClaim;
        return (A)this;
    }

    @Override
    public Boolean hasExternalM2WorkspaceClaim() {
        return this.externalM2WorkspaceClaim != null;
    }

    @Override
    @Deprecated
    public PersistentVolumeClaim getM2WorkspaceClaim() {
        return this.m2WorkspaceClaim != null ? this.m2WorkspaceClaim.build() : null;
    }

    @Override
    public PersistentVolumeClaim buildM2WorkspaceClaim() {
        return this.m2WorkspaceClaim != null ? this.m2WorkspaceClaim.build() : null;
    }

    @Override
    public A withM2WorkspaceClaim(PersistentVolumeClaim m2WorkspaceClaim) {
        this._visitables.get((Object)"m2WorkspaceClaim").remove(this.m2WorkspaceClaim);
        if (m2WorkspaceClaim != null) {
            this.m2WorkspaceClaim = new PersistentVolumeClaimBuilder(m2WorkspaceClaim);
            this._visitables.get((Object)"m2WorkspaceClaim").add(this.m2WorkspaceClaim);
        } else {
            this.m2WorkspaceClaim = null;
            this._visitables.get((Object)"m2WorkspaceClaim").remove(this.m2WorkspaceClaim);
        }
        return (A)this;
    }

    @Override
    public Boolean hasM2WorkspaceClaim() {
        return this.m2WorkspaceClaim != null;
    }

    @Override
    public TektonConfigFluent.M2WorkspaceClaimNested<A> withNewM2WorkspaceClaim() {
        return new M2WorkspaceClaimNestedImpl();
    }

    @Override
    public TektonConfigFluent.M2WorkspaceClaimNested<A> withNewM2WorkspaceClaimLike(PersistentVolumeClaim item) {
        return new M2WorkspaceClaimNestedImpl(item);
    }

    @Override
    public TektonConfigFluent.M2WorkspaceClaimNested<A> editM2WorkspaceClaim() {
        return this.withNewM2WorkspaceClaimLike(this.getM2WorkspaceClaim());
    }

    @Override
    public TektonConfigFluent.M2WorkspaceClaimNested<A> editOrNewM2WorkspaceClaim() {
        return this.withNewM2WorkspaceClaimLike(this.getM2WorkspaceClaim() != null ? this.getM2WorkspaceClaim() : new PersistentVolumeClaimBuilder().build());
    }

    @Override
    public TektonConfigFluent.M2WorkspaceClaimNested<A> editOrNewM2WorkspaceClaimLike(PersistentVolumeClaim item) {
        return this.withNewM2WorkspaceClaimLike(this.getM2WorkspaceClaim() != null ? this.getM2WorkspaceClaim() : item);
    }

    @Override
    public String getProjectBuilderImage() {
        return this.projectBuilderImage;
    }

    @Override
    public A withProjectBuilderImage(String projectBuilderImage) {
        this.projectBuilderImage = projectBuilderImage;
        return (A)this;
    }

    @Override
    public Boolean hasProjectBuilderImage() {
        return this.projectBuilderImage != null;
    }

    @Override
    public String getProjectBuilderCommand() {
        return this.projectBuilderCommand;
    }

    @Override
    public A withProjectBuilderCommand(String projectBuilderCommand) {
        this.projectBuilderCommand = projectBuilderCommand;
        return (A)this;
    }

    @Override
    public Boolean hasProjectBuilderCommand() {
        return this.projectBuilderCommand != null;
    }

    @Override
    public A withProjectBuilderArguments(String ... projectBuilderArguments) {
        if (this.projectBuilderArguments != null) {
            this.projectBuilderArguments.clear();
        }
        if (projectBuilderArguments != null) {
            for (String item : projectBuilderArguments) {
                this.addToProjectBuilderArguments(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getProjectBuilderArguments() {
        int size = this.projectBuilderArguments != null ? this.projectBuilderArguments.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.projectBuilderArguments) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToProjectBuilderArguments(Integer index, String item) {
        if (this.projectBuilderArguments == null) {
            this.projectBuilderArguments = new ArrayList<String>();
        }
        this.projectBuilderArguments.add(index, item);
        return (A)this;
    }

    @Override
    public A setToProjectBuilderArguments(Integer index, String item) {
        if (this.projectBuilderArguments == null) {
            this.projectBuilderArguments = new ArrayList<String>();
        }
        this.projectBuilderArguments.set(index, item);
        return (A)this;
    }

    @Override
    public A addToProjectBuilderArguments(String ... items) {
        if (this.projectBuilderArguments == null) {
            this.projectBuilderArguments = new ArrayList<String>();
        }
        for (String item : items) {
            this.projectBuilderArguments.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToProjectBuilderArguments(Collection<String> items) {
        if (this.projectBuilderArguments == null) {
            this.projectBuilderArguments = new ArrayList<String>();
        }
        for (String item : items) {
            this.projectBuilderArguments.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromProjectBuilderArguments(String ... items) {
        for (String item : items) {
            if (this.projectBuilderArguments == null) continue;
            this.projectBuilderArguments.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromProjectBuilderArguments(Collection<String> items) {
        for (String item : items) {
            if (this.projectBuilderArguments == null) continue;
            this.projectBuilderArguments.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasProjectBuilderArguments() {
        return this.projectBuilderArguments != null && !this.projectBuilderArguments.isEmpty();
    }

    @Override
    public TektonImageBuildStrategy getImageBuildStrategy() {
        return this.imageBuildStrategy;
    }

    @Override
    public A withImageBuildStrategy(TektonImageBuildStrategy imageBuildStrategy) {
        this.imageBuildStrategy = imageBuildStrategy;
        return (A)this;
    }

    @Override
    public Boolean hasImageBuildStrategy() {
        return this.imageBuildStrategy != null;
    }

    @Override
    public String getImageBuildImage() {
        return this.imageBuildImage;
    }

    @Override
    public A withImageBuildImage(String imageBuildImage) {
        this.imageBuildImage = imageBuildImage;
        return (A)this;
    }

    @Override
    public Boolean hasImageBuildImage() {
        return this.imageBuildImage != null;
    }

    @Override
    public String getImageBuildCommand() {
        return this.imageBuildCommand;
    }

    @Override
    public A withImageBuildCommand(String imageBuildCommand) {
        this.imageBuildCommand = imageBuildCommand;
        return (A)this;
    }

    @Override
    public Boolean hasImageBuildCommand() {
        return this.imageBuildCommand != null;
    }

    @Override
    public A withImageBuildArguments(String ... imageBuildArguments) {
        if (this.imageBuildArguments != null) {
            this.imageBuildArguments.clear();
        }
        if (imageBuildArguments != null) {
            for (String item : imageBuildArguments) {
                this.addToImageBuildArguments(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getImageBuildArguments() {
        int size = this.imageBuildArguments != null ? this.imageBuildArguments.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.imageBuildArguments) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToImageBuildArguments(Integer index, String item) {
        if (this.imageBuildArguments == null) {
            this.imageBuildArguments = new ArrayList<String>();
        }
        this.imageBuildArguments.add(index, item);
        return (A)this;
    }

    @Override
    public A setToImageBuildArguments(Integer index, String item) {
        if (this.imageBuildArguments == null) {
            this.imageBuildArguments = new ArrayList<String>();
        }
        this.imageBuildArguments.set(index, item);
        return (A)this;
    }

    @Override
    public A addToImageBuildArguments(String ... items) {
        if (this.imageBuildArguments == null) {
            this.imageBuildArguments = new ArrayList<String>();
        }
        for (String item : items) {
            this.imageBuildArguments.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToImageBuildArguments(Collection<String> items) {
        if (this.imageBuildArguments == null) {
            this.imageBuildArguments = new ArrayList<String>();
        }
        for (String item : items) {
            this.imageBuildArguments.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromImageBuildArguments(String ... items) {
        for (String item : items) {
            if (this.imageBuildArguments == null) continue;
            this.imageBuildArguments.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImageBuildArguments(Collection<String> items) {
        for (String item : items) {
            if (this.imageBuildArguments == null) continue;
            this.imageBuildArguments.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasImageBuildArguments() {
        return this.imageBuildArguments != null && !this.imageBuildArguments.isEmpty();
    }

    @Override
    public String getImagePushImage() {
        return this.imagePushImage;
    }

    @Override
    public A withImagePushImage(String imagePushImage) {
        this.imagePushImage = imagePushImage;
        return (A)this;
    }

    @Override
    public Boolean hasImagePushImage() {
        return this.imagePushImage != null;
    }

    @Override
    public String getImagePushCommand() {
        return this.imagePushCommand;
    }

    @Override
    public A withImagePushCommand(String imagePushCommand) {
        this.imagePushCommand = imagePushCommand;
        return (A)this;
    }

    @Override
    public Boolean hasImagePushCommand() {
        return this.imagePushCommand != null;
    }

    @Override
    public A withImagePushArguments(String ... imagePushArguments) {
        if (this.imagePushArguments != null) {
            this.imagePushArguments.clear();
        }
        if (imagePushArguments != null) {
            for (String item : imagePushArguments) {
                this.addToImagePushArguments(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getImagePushArguments() {
        int size = this.imagePushArguments != null ? this.imagePushArguments.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.imagePushArguments) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToImagePushArguments(Integer index, String item) {
        if (this.imagePushArguments == null) {
            this.imagePushArguments = new ArrayList<String>();
        }
        this.imagePushArguments.add(index, item);
        return (A)this;
    }

    @Override
    public A setToImagePushArguments(Integer index, String item) {
        if (this.imagePushArguments == null) {
            this.imagePushArguments = new ArrayList<String>();
        }
        this.imagePushArguments.set(index, item);
        return (A)this;
    }

    @Override
    public A addToImagePushArguments(String ... items) {
        if (this.imagePushArguments == null) {
            this.imagePushArguments = new ArrayList<String>();
        }
        for (String item : items) {
            this.imagePushArguments.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToImagePushArguments(Collection<String> items) {
        if (this.imagePushArguments == null) {
            this.imagePushArguments = new ArrayList<String>();
        }
        for (String item : items) {
            this.imagePushArguments.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromImagePushArguments(String ... items) {
        for (String item : items) {
            if (this.imagePushArguments == null) continue;
            this.imagePushArguments.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImagePushArguments(Collection<String> items) {
        for (String item : items) {
            if (this.imagePushArguments == null) continue;
            this.imagePushArguments.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasImagePushArguments() {
        return this.imagePushArguments != null && !this.imagePushArguments.isEmpty();
    }

    @Override
    public String getDockerfile() {
        return this.dockerfile;
    }

    @Override
    public A withDockerfile(String dockerfile) {
        this.dockerfile = dockerfile;
        return (A)this;
    }

    @Override
    public Boolean hasDockerfile() {
        return this.dockerfile != null;
    }

    @Override
    public String getDeployerImage() {
        return this.deployerImage;
    }

    @Override
    public A withDeployerImage(String deployerImage) {
        this.deployerImage = deployerImage;
        return (A)this;
    }

    @Override
    public Boolean hasDeployerImage() {
        return this.deployerImage != null;
    }

    @Override
    public String getImagePushServiceAccount() {
        return this.imagePushServiceAccount;
    }

    @Override
    public A withImagePushServiceAccount(String imagePushServiceAccount) {
        this.imagePushServiceAccount = imagePushServiceAccount;
        return (A)this;
    }

    @Override
    public Boolean hasImagePushServiceAccount() {
        return this.imagePushServiceAccount != null;
    }

    @Override
    public String getImagePushSecret() {
        return this.imagePushSecret;
    }

    @Override
    public A withImagePushSecret(String imagePushSecret) {
        this.imagePushSecret = imagePushSecret;
        return (A)this;
    }

    @Override
    public Boolean hasImagePushSecret() {
        return this.imagePushSecret != null;
    }

    @Override
    public Boolean getUseLocalDockerConfigJson() {
        return this.useLocalDockerConfigJson;
    }

    @Override
    public A withUseLocalDockerConfigJson(Boolean useLocalDockerConfigJson) {
        this.useLocalDockerConfigJson = useLocalDockerConfigJson;
        return (A)this;
    }

    @Override
    public Boolean hasUseLocalDockerConfigJson() {
        return this.useLocalDockerConfigJson != null;
    }

    @Override
    public String getRegistry() {
        return this.registry;
    }

    @Override
    public A withRegistry(String registry) {
        this.registry = registry;
        return (A)this;
    }

    @Override
    public Boolean hasRegistry() {
        return this.registry != null;
    }

    @Override
    public String getRegistryUsername() {
        return this.registryUsername;
    }

    @Override
    public A withRegistryUsername(String registryUsername) {
        this.registryUsername = registryUsername;
        return (A)this;
    }

    @Override
    public Boolean hasRegistryUsername() {
        return this.registryUsername != null;
    }

    @Override
    public String getRegistryPassword() {
        return this.registryPassword;
    }

    @Override
    public A withRegistryPassword(String registryPassword) {
        this.registryPassword = registryPassword;
        return (A)this;
    }

    @Override
    public Boolean hasRegistryPassword() {
        return this.registryPassword != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TektonConfigFluentImpl that = (TektonConfigFluentImpl)o;
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.externalGitPipelineResource != null ? !this.externalGitPipelineResource.equals(that.externalGitPipelineResource) : that.externalGitPipelineResource != null) {
            return false;
        }
        if (this.sourceWorkspace != null ? !this.sourceWorkspace.equals(that.sourceWorkspace) : that.sourceWorkspace != null) {
            return false;
        }
        if (this.externalSourceWorkspaceClaim != null ? !this.externalSourceWorkspaceClaim.equals(that.externalSourceWorkspaceClaim) : that.externalSourceWorkspaceClaim != null) {
            return false;
        }
        if (this.sourceWorkspaceClaim != null ? !this.sourceWorkspaceClaim.equals(that.sourceWorkspaceClaim) : that.sourceWorkspaceClaim != null) {
            return false;
        }
        if (this.m2Workspace != null ? !this.m2Workspace.equals(that.m2Workspace) : that.m2Workspace != null) {
            return false;
        }
        if (this.externalM2WorkspaceClaim != null ? !this.externalM2WorkspaceClaim.equals(that.externalM2WorkspaceClaim) : that.externalM2WorkspaceClaim != null) {
            return false;
        }
        if (this.m2WorkspaceClaim != null ? !this.m2WorkspaceClaim.equals(that.m2WorkspaceClaim) : that.m2WorkspaceClaim != null) {
            return false;
        }
        if (this.projectBuilderImage != null ? !this.projectBuilderImage.equals(that.projectBuilderImage) : that.projectBuilderImage != null) {
            return false;
        }
        if (this.projectBuilderCommand != null ? !this.projectBuilderCommand.equals(that.projectBuilderCommand) : that.projectBuilderCommand != null) {
            return false;
        }
        if (this.projectBuilderArguments != null ? !this.projectBuilderArguments.equals(that.projectBuilderArguments) : that.projectBuilderArguments != null) {
            return false;
        }
        if (this.imageBuildStrategy != null ? !this.imageBuildStrategy.equals((Object)that.imageBuildStrategy) : that.imageBuildStrategy != null) {
            return false;
        }
        if (this.imageBuildImage != null ? !this.imageBuildImage.equals(that.imageBuildImage) : that.imageBuildImage != null) {
            return false;
        }
        if (this.imageBuildCommand != null ? !this.imageBuildCommand.equals(that.imageBuildCommand) : that.imageBuildCommand != null) {
            return false;
        }
        if (this.imageBuildArguments != null ? !this.imageBuildArguments.equals(that.imageBuildArguments) : that.imageBuildArguments != null) {
            return false;
        }
        if (this.imagePushImage != null ? !this.imagePushImage.equals(that.imagePushImage) : that.imagePushImage != null) {
            return false;
        }
        if (this.imagePushCommand != null ? !this.imagePushCommand.equals(that.imagePushCommand) : that.imagePushCommand != null) {
            return false;
        }
        if (this.imagePushArguments != null ? !this.imagePushArguments.equals(that.imagePushArguments) : that.imagePushArguments != null) {
            return false;
        }
        if (this.dockerfile != null ? !this.dockerfile.equals(that.dockerfile) : that.dockerfile != null) {
            return false;
        }
        if (this.deployerImage != null ? !this.deployerImage.equals(that.deployerImage) : that.deployerImage != null) {
            return false;
        }
        if (this.imagePushServiceAccount != null ? !this.imagePushServiceAccount.equals(that.imagePushServiceAccount) : that.imagePushServiceAccount != null) {
            return false;
        }
        if (this.imagePushSecret != null ? !this.imagePushSecret.equals(that.imagePushSecret) : that.imagePushSecret != null) {
            return false;
        }
        if (this.useLocalDockerConfigJson != null ? !this.useLocalDockerConfigJson.equals(that.useLocalDockerConfigJson) : that.useLocalDockerConfigJson != null) {
            return false;
        }
        if (this.registry != null ? !this.registry.equals(that.registry) : that.registry != null) {
            return false;
        }
        if (this.registryUsername != null ? !this.registryUsername.equals(that.registryUsername) : that.registryUsername != null) {
            return false;
        }
        return !(this.registryPassword != null ? !this.registryPassword.equals(that.registryPassword) : that.registryPassword != null);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.labels, this.annotations, this.externalGitPipelineResource, this.sourceWorkspace, this.externalSourceWorkspaceClaim, this.sourceWorkspaceClaim, this.m2Workspace, this.externalM2WorkspaceClaim, this.m2WorkspaceClaim, this.projectBuilderImage, this.projectBuilderCommand, this.projectBuilderArguments, this.imageBuildStrategy, this.imageBuildImage, this.imageBuildCommand, this.imageBuildArguments, this.imagePushImage, this.imagePushCommand, this.imagePushArguments, this.dockerfile, this.deployerImage, this.imagePushServiceAccount, this.imagePushSecret, this.useLocalDockerConfigJson, this.registry, this.registryUsername, this.registryPassword, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(this.labels + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.externalGitPipelineResource != null) {
            sb.append("externalGitPipelineResource:");
            sb.append(this.externalGitPipelineResource + ",");
        }
        if (this.sourceWorkspace != null) {
            sb.append("sourceWorkspace:");
            sb.append(this.sourceWorkspace + ",");
        }
        if (this.externalSourceWorkspaceClaim != null) {
            sb.append("externalSourceWorkspaceClaim:");
            sb.append(this.externalSourceWorkspaceClaim + ",");
        }
        if (this.sourceWorkspaceClaim != null) {
            sb.append("sourceWorkspaceClaim:");
            sb.append(this.sourceWorkspaceClaim + ",");
        }
        if (this.m2Workspace != null) {
            sb.append("m2Workspace:");
            sb.append(this.m2Workspace + ",");
        }
        if (this.externalM2WorkspaceClaim != null) {
            sb.append("externalM2WorkspaceClaim:");
            sb.append(this.externalM2WorkspaceClaim + ",");
        }
        if (this.m2WorkspaceClaim != null) {
            sb.append("m2WorkspaceClaim:");
            sb.append(this.m2WorkspaceClaim + ",");
        }
        if (this.projectBuilderImage != null) {
            sb.append("projectBuilderImage:");
            sb.append(this.projectBuilderImage + ",");
        }
        if (this.projectBuilderCommand != null) {
            sb.append("projectBuilderCommand:");
            sb.append(this.projectBuilderCommand + ",");
        }
        if (this.projectBuilderArguments != null && !this.projectBuilderArguments.isEmpty()) {
            sb.append("projectBuilderArguments:");
            sb.append(this.projectBuilderArguments + ",");
        }
        if (this.imageBuildStrategy != null) {
            sb.append("imageBuildStrategy:");
            sb.append((Object)((Object)this.imageBuildStrategy) + ",");
        }
        if (this.imageBuildImage != null) {
            sb.append("imageBuildImage:");
            sb.append(this.imageBuildImage + ",");
        }
        if (this.imageBuildCommand != null) {
            sb.append("imageBuildCommand:");
            sb.append(this.imageBuildCommand + ",");
        }
        if (this.imageBuildArguments != null && !this.imageBuildArguments.isEmpty()) {
            sb.append("imageBuildArguments:");
            sb.append(this.imageBuildArguments + ",");
        }
        if (this.imagePushImage != null) {
            sb.append("imagePushImage:");
            sb.append(this.imagePushImage + ",");
        }
        if (this.imagePushCommand != null) {
            sb.append("imagePushCommand:");
            sb.append(this.imagePushCommand + ",");
        }
        if (this.imagePushArguments != null && !this.imagePushArguments.isEmpty()) {
            sb.append("imagePushArguments:");
            sb.append(this.imagePushArguments + ",");
        }
        if (this.dockerfile != null) {
            sb.append("dockerfile:");
            sb.append(this.dockerfile + ",");
        }
        if (this.deployerImage != null) {
            sb.append("deployerImage:");
            sb.append(this.deployerImage + ",");
        }
        if (this.imagePushServiceAccount != null) {
            sb.append("imagePushServiceAccount:");
            sb.append(this.imagePushServiceAccount + ",");
        }
        if (this.imagePushSecret != null) {
            sb.append("imagePushSecret:");
            sb.append(this.imagePushSecret + ",");
        }
        if (this.useLocalDockerConfigJson != null) {
            sb.append("useLocalDockerConfigJson:");
            sb.append(this.useLocalDockerConfigJson + ",");
        }
        if (this.registry != null) {
            sb.append("registry:");
            sb.append(this.registry + ",");
        }
        if (this.registryUsername != null) {
            sb.append("registryUsername:");
            sb.append(this.registryUsername + ",");
        }
        if (this.registryPassword != null) {
            sb.append("registryPassword:");
            sb.append(this.registryPassword);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withUseLocalDockerConfigJson() {
        return this.withUseLocalDockerConfigJson(true);
    }

    class M2WorkspaceClaimNestedImpl<N>
    extends PersistentVolumeClaimFluentImpl<TektonConfigFluent.M2WorkspaceClaimNested<N>>
    implements TektonConfigFluent.M2WorkspaceClaimNested<N>,
    Nested<N> {
        PersistentVolumeClaimBuilder builder;

        M2WorkspaceClaimNestedImpl(PersistentVolumeClaim item) {
            this.builder = new PersistentVolumeClaimBuilder(this, item);
        }

        M2WorkspaceClaimNestedImpl() {
            this.builder = new PersistentVolumeClaimBuilder(this);
        }

        @Override
        public N and() {
            return (N)TektonConfigFluentImpl.this.withM2WorkspaceClaim(this.builder.build());
        }

        @Override
        public N endM2WorkspaceClaim() {
            return this.and();
        }
    }

    class SourceWorkspaceClaimNestedImpl<N>
    extends PersistentVolumeClaimFluentImpl<TektonConfigFluent.SourceWorkspaceClaimNested<N>>
    implements TektonConfigFluent.SourceWorkspaceClaimNested<N>,
    Nested<N> {
        PersistentVolumeClaimBuilder builder;

        SourceWorkspaceClaimNestedImpl(PersistentVolumeClaim item) {
            this.builder = new PersistentVolumeClaimBuilder(this, item);
        }

        SourceWorkspaceClaimNestedImpl() {
            this.builder = new PersistentVolumeClaimBuilder(this);
        }

        @Override
        public N and() {
            return (N)TektonConfigFluentImpl.this.withSourceWorkspaceClaim(this.builder.build());
        }

        @Override
        public N endSourceWorkspaceClaim() {
            return this.and();
        }
    }

    class AnnotationsNestedImpl<N>
    extends AnnotationFluentImpl<TektonConfigFluent.AnnotationsNested<N>>
    implements TektonConfigFluent.AnnotationsNested<N>,
    Nested<N> {
        AnnotationBuilder builder;
        Integer index;

        AnnotationsNestedImpl(Integer index, Annotation item) {
            this.index = index;
            this.builder = new AnnotationBuilder((AnnotationFluent)this, item);
        }

        AnnotationsNestedImpl() {
            this.index = -1;
            this.builder = new AnnotationBuilder((AnnotationFluent)this);
        }

        @Override
        public N and() {
            return (N)TektonConfigFluentImpl.this.setToAnnotations(this.index, (Annotation)this.builder.build());
        }

        @Override
        public N endAnnotation() {
            return this.and();
        }
    }

    class LabelsNestedImpl<N>
    extends LabelFluentImpl<TektonConfigFluent.LabelsNested<N>>
    implements TektonConfigFluent.LabelsNested<N>,
    Nested<N> {
        LabelBuilder builder;
        Integer index;

        LabelsNestedImpl(Integer index, Label item) {
            this.index = index;
            this.builder = new LabelBuilder((LabelFluent)this, item);
        }

        LabelsNestedImpl() {
            this.index = -1;
            this.builder = new LabelBuilder((LabelFluent)this);
        }

        @Override
        public N and() {
            return (N)TektonConfigFluentImpl.this.setToLabels(this.index, (Label)this.builder.build());
        }

        @Override
        public N endLabel() {
            return this.and();
        }
    }
}

