/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.tekton.configurator;

import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.PersistentVolumeClaim;
import io.dekorate.tekton.config.TektonConfigFluent;
import io.dekorate.utils.Strings;

public class ApplyTektonMavenWorkspaceConfigurator
extends Configurator<TektonConfigFluent<?>> {
    private final String workspace;
    private final String claim;
    private final PersistentVolumeClaim pvc;

    public ApplyTektonMavenWorkspaceConfigurator(String workspace) {
        this(workspace, null, null);
    }

    public ApplyTektonMavenWorkspaceConfigurator(String workspace, String claim) {
        this(workspace, claim, null);
    }

    public ApplyTektonMavenWorkspaceConfigurator(String workspace, String claim, PersistentVolumeClaim pvc) {
        this.workspace = workspace;
        this.claim = claim;
        this.pvc = pvc;
    }

    public void visit(TektonConfigFluent<?> config) {
        if (!Strings.isNotNullOrEmpty((String)this.workspace)) {
            config.withM2Workspace(this.workspace);
        }
        if (!Strings.isNotNullOrEmpty((String)this.claim)) {
            config.withExternalM2WorkspaceClaim(this.claim);
        }
        if (this.pvc != null) {
            config.withM2WorkspaceClaim(this.pvc);
        }
    }
}

