/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.tekton.configurator;

import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.PersistentVolumeClaim;
import io.dekorate.tekton.config.TektonConfigFluent;
import io.dekorate.utils.Strings;

public class ApplyTektonSourceWorkspaceConfigurator
extends Configurator<TektonConfigFluent<?>> {
    private final String workspace;
    private final String claim;
    private final PersistentVolumeClaim pvc;

    public ApplyTektonSourceWorkspaceConfigurator(String workspace) {
        this(workspace, null, null);
    }

    public ApplyTektonSourceWorkspaceConfigurator(String workspace, String claim) {
        this(workspace, claim, null);
    }

    public ApplyTektonSourceWorkspaceConfigurator(String workspace, String claim, PersistentVolumeClaim pvc) {
        this.workspace = workspace;
        this.claim = claim;
        this.pvc = pvc;
    }

    public void visit(TektonConfigFluent<?> config) {
        if (!Strings.isNotNullOrEmpty((String)this.workspace)) {
            config.withSourceWorkspace(this.workspace);
        }
        if (!Strings.isNotNullOrEmpty((String)this.claim)) {
            config.withExternalSourceWorkspaceClaim(this.claim);
        }
        if (this.pvc != null) {
            config.withSourceWorkspaceClaim(this.pvc);
        }
    }
}

