/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.tekton.decorator;

import io.dekorate.doc.Description;
import io.dekorate.tekton.decorator.NamedTaskDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.tekton.pipeline.v1beta1.TaskSpecFluent;
import java.util.function.Predicate;

@Description(value="Add a persistent host path volume to the specified task.")
public class AddHostPathVolumeDecorator
extends NamedTaskDecorator {
    private final String name;
    private final String path;
    private final String type;

    public AddHostPathVolumeDecorator(String taskName, String name, String path, String type) {
        super(taskName);
        this.name = name;
        this.path = path;
        this.type = type;
    }

    @Override
    public void andThenVisit(TaskSpecFluent<?> spec) {
        Predicate<VolumeBuilder> predicate = AddHostPathVolumeDecorator.matchingVolume(this.name);
        if (spec.hasMatchingVolume(predicate).booleanValue()) {
            spec.removeMatchingFromVolumes(predicate);
        }
        spec.addToVolumes(new Volume[]{((VolumeBuilder)((VolumeFluent.HostPathNested)((VolumeFluent.HostPathNested)((VolumeBuilder)new VolumeBuilder().withName(this.name)).withNewHostPath().withType(this.type)).withPath(this.path)).endHostPath()).build()});
    }

    private static Predicate<VolumeBuilder> matchingVolume(final String name) {
        return new Predicate<VolumeBuilder>(){

            @Override
            public boolean test(VolumeBuilder volume) {
                return Strings.isNullOrEmpty((String)name) || volume.getName().equals(name);
            }
        };
    }
}

