/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.tekton.decorator;

import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.tekton.decorator.AddInitStepDecorator;
import io.dekorate.tekton.decorator.AddProjectBuildStepDecorator;
import io.dekorate.tekton.decorator.NamedTaskDecorator;
import io.dekorate.tekton.decorator.StepDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.tekton.pipeline.v1beta1.TaskSpecFluent;

public class AddImagePushStepDecorator
extends NamedTaskDecorator
implements StepDecorator {
    private static final String PUSH_IMAGE_REF = "$(inputs.params.imagePushImage)";
    private static final String PUSH_COMMAND_REF = "$(inputs.params.imagePushCommand)";
    private static final String PUSH_ARGS_REF = "$(inputs.params.imagePushArgs[*])";
    private static final String DOCKER_CONFIG = "DOCKER_CONFIG";
    private static final String DOCKER_CONFIG_DEFAULT = "/tekton/home/.docker";
    private final String stepName;
    private final String projectName;
    private final String image;
    private final String command;
    private final String[] args;

    public AddImagePushStepDecorator(String taskName, String projectName) {
        this(taskName, "image-push", projectName);
    }

    public AddImagePushStepDecorator(String taskName, String stepName, String projectName) {
        this(taskName, stepName, projectName, PUSH_IMAGE_REF, PUSH_COMMAND_REF, PUSH_ARGS_REF);
    }

    public AddImagePushStepDecorator(String taskName, String stepName, String projectName, String image, String command, String ... args) {
        super(taskName);
        String[] stringArray;
        this.stepName = stepName;
        this.projectName = projectName;
        this.image = Strings.isNotNullOrEmpty((String)image) ? image : PUSH_IMAGE_REF;
        String string = this.command = Strings.isNotNullOrEmpty((String)command) ? command : PUSH_COMMAND_REF;
        if (args != null && args.length != 0) {
            stringArray = args;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = PUSH_ARGS_REF;
        }
        this.args = stringArray;
    }

    @Override
    public void andThenVisit(TaskSpecFluent<?> taskSpec) {
        ((TaskSpecFluent.StepsNested)((TaskSpecFluent.StepsNested)((TaskSpecFluent.StepsNested)((TaskSpecFluent.StepsNested)((TaskSpecFluent.StepsNested)((TaskSpecFluent.StepsNested)taskSpec.addNewStep().withName(this.stepName)).withImage(this.image)).addToEnv(new EnvVar[]{((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName(DOCKER_CONFIG)).withValue(DOCKER_CONFIG_DEFAULT)).build()})).withCommand(new String[]{this.command})).withArgs(this.args)).withWorkingDir(this.sourcePath(new String[]{this.projectName}))).endStep();
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{AddInitStepDecorator.class, AddProjectBuildStepDecorator.class};
    }
}

