/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.tekton.decorator;

import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.tekton.decorator.AddInitStepDecorator;
import io.dekorate.tekton.decorator.AddProjectBuildStepDecorator;
import io.dekorate.tekton.decorator.NamedTaskDecorator;
import io.dekorate.tekton.decorator.StepDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.tekton.pipeline.v1beta1.TaskSpecFluent;

public class AddKanikoImageBuildStepDecorator
extends NamedTaskDecorator
implements StepDecorator {
    private static final String STEP_NAME = "image-build";
    private static final String BUILDER_IMAGE_REF = "$(inputs.params.imageBuilderImage)";
    private static final String BUILDER_COMMAND_REF = "$(inputs.params.imageBuilderCommand)";
    private static final String BUILDER_ARGS_REF = "$(inputs.params.imageBuilderArgs[*])";
    private static final String KANIKO_CMD = "/kaniko/executor";
    private static final String DOCKERFILE_ARG = "--dockerfile=$(inputs.params.pathToDockerfile)";
    private static final String CONTEXT_ARG = "--context=$(params.pathToContext)";
    private static final String IMAGE_DESTINATION_ARG = "--destination=$(resources.outputs.image.url)";
    private static final String VERBOSITY_DEBUG = "--verbosity=debug";
    private static final String DOCKER_CONFIG = "DOCKER_CONFIG";
    private static final String DOCKER_CONFIG_DEFAULT = "/tekton/home/.docker";
    private final String stepName;
    private final String projectName;
    private final String image;
    private final String command;
    private final String[] args;

    public AddKanikoImageBuildStepDecorator(String taskName, String projectName) {
        this(taskName, STEP_NAME, projectName);
    }

    public AddKanikoImageBuildStepDecorator(String taskName, String stepName, String projectName) {
        this(taskName, stepName, projectName, BUILDER_IMAGE_REF, BUILDER_COMMAND_REF, BUILDER_ARGS_REF);
    }

    public AddKanikoImageBuildStepDecorator(String taskName, String stepName, String projectName, String image, String command, String ... args) {
        super(taskName);
        String[] stringArray;
        this.stepName = stepName;
        this.projectName = projectName;
        this.image = Strings.isNotNullOrEmpty((String)image) ? image : BUILDER_IMAGE_REF;
        String string = this.command = Strings.isNotNullOrEmpty((String)command) ? command : KANIKO_CMD;
        if (args != null && args.length != 0) {
            stringArray = args;
        } else {
            String[] stringArray2 = new String[4];
            stringArray2[0] = DOCKERFILE_ARG;
            stringArray2[1] = CONTEXT_ARG;
            stringArray2[2] = IMAGE_DESTINATION_ARG;
            stringArray = stringArray2;
            stringArray2[3] = VERBOSITY_DEBUG;
        }
        this.args = stringArray;
    }

    @Override
    public void andThenVisit(TaskSpecFluent<?> taskSpec) {
        ((TaskSpecFluent.StepsNested)((TaskSpecFluent.StepsNested)((TaskSpecFluent.StepsNested)((TaskSpecFluent.StepsNested)((TaskSpecFluent.StepsNested)((TaskSpecFluent.StepsNested)taskSpec.addNewStep().withName(this.stepName)).withImage(this.image)).addToEnv(new EnvVar[]{((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName(DOCKER_CONFIG)).withValue(DOCKER_CONFIG_DEFAULT)).build()})).withCommand(new String[]{this.command})).withArgs(this.args)).withWorkingDir(this.sourcePath(new String[]{this.projectName}))).endStep();
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{AddInitStepDecorator.class, AddProjectBuildStepDecorator.class};
    }
}

