/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.tekton.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.tekton.decorator.ApplyArgsDecorator;
import io.dekorate.tekton.decorator.NamedTaskDecorator;
import io.dekorate.tekton.decorator.TektonStepDecorator;
import io.fabric8.tekton.pipeline.v1beta1.StepFluent;

@Description(value="A decorator that applies the command args to the task step.")
public class AddToArgsDecorator
extends TektonStepDecorator<StepFluent> {
    private final String[] argument;

    public AddToArgsDecorator(String taskName, String stepName, String ... argument) {
        super(taskName, stepName);
        this.argument = argument;
    }

    @Override
    public void andThenVisit(StepFluent step) {
        if (this.isApplicable(step) && this.argument != null && this.argument.length > 0) {
            step.addToArgs(this.argument);
        }
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, NamedTaskDecorator.class, ApplyArgsDecorator.class};
    }
}

