/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.tekton.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.tekton.decorator.TektonStepDecorator;
import io.fabric8.tekton.pipeline.v1beta1.StepFluent;

@Description(value="A decorator that applies the command to the application container.")
public class ApplyCommandDecorator
extends TektonStepDecorator<StepFluent> {
    private final String[] command;

    public ApplyCommandDecorator(String containerName, String ... command) {
        super(null, containerName);
        this.command = command;
    }

    public ApplyCommandDecorator(String deployment, String container, String ... command) {
        super(deployment, container);
        this.command = command;
    }

    @Override
    public void andThenVisit(StepFluent step) {
        if (this.isApplicable(step) && this.command != null && this.command.length > 0) {
            step.withCommand(this.command);
        }
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class};
    }
}

