/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.tekton.decorator;

import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.tekton.decorator.TaskProvidingDecorator;
import io.dekorate.tekton.decorator.TektonStepDecorator;
import io.dekorate.utils.Generics;
import io.dekorate.utils.Metadata;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.tekton.pipeline.v1beta1.StepBuilder;
import java.util.Optional;

public abstract class NamedStepDecorator<T>
extends Decorator<VisitableBuilder> {
    protected static final String ANY = null;
    private final String taskName;
    private final String stepName;
    private final TaskVisitor taskVisitor = new TaskVisitor();
    private final StepVisitor stepVisitor = new StepVisitor();

    public NamedStepDecorator(String taskName, String stepName) {
        this.taskName = taskName;
        this.stepName = stepName;
    }

    public void visit(VisitableBuilder builder) {
        Optional objectMeta = Metadata.getMetadata((Builder)builder);
        if (!objectMeta.isPresent()) {
            return;
        }
        if (Strings.isNullOrEmpty((String)this.taskName) || objectMeta.map(m -> m.getName()).filter(s -> s.equals(this.taskName)).isPresent()) {
            builder.accept(new Visitor[]{this.taskVisitor});
        }
    }

    public abstract void andThenVisit(T var1);

    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, TaskProvidingDecorator.class};
    }

    public Class<? extends Decorator>[] before() {
        return new Class[]{TektonStepDecorator.class};
    }

    private class StepVisitor
    extends TypedVisitor<T> {
        private StepVisitor() {
        }

        public void visit(T item) {
            NamedStepDecorator.this.andThenVisit(item);
        }

        public Class<T> getType() {
            return (Class)Generics.getTypeArguments(NamedStepDecorator.class, ((Object)((Object)NamedStepDecorator.this)).getClass()).get(0);
        }
    }

    private class TaskVisitor
    extends TypedVisitor<StepBuilder> {
        private TaskVisitor() {
        }

        public void visit(StepBuilder step) {
            if (Strings.isNullOrEmpty((String)NamedStepDecorator.this.stepName) || NamedStepDecorator.this.stepName.equals(step.getName())) {
                step.accept(new Visitor[]{NamedStepDecorator.this.stepVisitor});
            }
        }
    }
}

